/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.construct;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.module.extension.mule.internal.construct.DefaultOperationBuilder;
import org.mule.runtime.module.extension.mule.internal.construct.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleOperation
extends AbstractComponent
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleOperation.class);
    private final List<Processor> processors;
    private final OperationModel operationModel;
    private final MuleContext muleContext;
    private MessageProcessorChain chain;
    private ProcessingStrategy processingStrategy;

    public static Operation.Builder builder() {
        return new DefaultOperationBuilder();
    }

    MuleOperation(List<Processor> processors, OperationModel operationModel, MuleContext muleContext) {
        this.processors = processors;
        this.operationModel = operationModel;
        this.muleContext = muleContext;
    }

    @Override
    public CompletableFuture<ExecutionResult> execute(InputEvent inputEvent) {
        return this.chain.execute(inputEvent);
    }

    @Override
    public CompletableFuture<Event> execute(Event event) {
        return this.chain.execute(event);
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.processingStrategy = MessageProcessors.getDefaultProcessingStrategyFactory(this.muleContext.getConfiguration()).create(((MuleContextWithRegistry)this.muleContext).getRegistry().lookupObject(InternalProfilingService.class), ((MuleContextWithRegistry)this.muleContext).getRegistry().lookupObject(FeatureFlaggingService.class), this.muleContext.getSchedulerService(), this.muleContext::getSchedulerBaseConfig, this.operationModel.getName(), this.muleContext.getConfiguration().getId(), ArtifactType.valueOf(this.muleContext.getArtifactType().name()), () -> this.muleContext.getConfiguration().getShutdownTimeout());
        }
        catch (RegistrationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded(this.processingStrategy);
        this.chain = MessageProcessors.newChain(Optional.ofNullable(this.processingStrategy), this.processors, this.getLocation().getLocation(), null);
        LifecycleUtils.initialiseIfNeeded((Object)this.chain, this.muleContext.getInjector());
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processingStrategy);
        LifecycleUtils.startIfNeeded(this.chain);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.chain);
        LifecycleUtils.stopIfNeeded(this.processingStrategy);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.chain, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.processingStrategy, LOGGER);
    }

    @Override
    public OperationModel getModel() {
        return this.operationModel;
    }
}

