/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.tooling;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.deployment.model.internal.tooling.ToolingRegionClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;

public class ToolingApplicationClassLoaderBuilder
extends AbstractArtifactClassLoaderBuilder<ToolingApplicationClassLoaderBuilder> {
    private final DeployableArtifactClassLoaderFactory artifactClassLoaderFactory;
    private ArtifactClassLoader parentClassLoader;
    private boolean usesCustomDomain = false;

    public ToolingApplicationClassLoaderBuilder(DeployableArtifactClassLoaderFactory<ApplicationDescriptor> artifactClassLoaderFactory, RegionPluginClassLoadersFactory pluginClassLoadersFactory) {
        super(pluginClassLoadersFactory);
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    @Override
    public ToolingArtifactClassLoader build() {
        ArtifactClassLoader ownerArtifactClassLoader = super.build();
        ClassLoader parent = ownerArtifactClassLoader.getClassLoader().getParent();
        if (!(parent instanceof RegionClassLoader)) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(String.format("The parent of the current owner must be of type '%s' but found '%s'", RegionClassLoader.class.getName(), parent.getClass().getName())));
        }
        RegionClassLoader regionClassLoader = (RegionClassLoader)parent;
        return new ToolingArtifactClassLoader(regionClassLoader, ownerArtifactClassLoader);
    }

    @Override
    protected ArtifactClassLoader createArtifactClassLoader(String artifactId, RegionClassLoader regionClassLoader) {
        return this.artifactClassLoaderFactory.create(artifactId, regionClassLoader, this.artifactDescriptor);
    }

    @Override
    protected String getArtifactId(ArtifactDescriptor artifactDescriptor) {
        if (this.usesCustomDomain) {
            return ToolingApplicationClassLoaderBuilder.getApplicationId(artifactDescriptor.getName(), this.parentClassLoader.getArtifactId());
        }
        return ToolingApplicationClassLoaderBuilder.getApplicationId(artifactDescriptor.getName());
    }

    public ToolingApplicationClassLoaderBuilder setParentClassLoader(ArtifactClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        return this;
    }

    public ToolingApplicationClassLoaderBuilder setDomainParentClassLoader(ArtifactClassLoader domainArtifactClassLoader) {
        this.parentClassLoader = domainArtifactClassLoader;
        this.usesCustomDomain = true;
        return this;
    }

    @Override
    protected ClassLoaderLookupPolicy getParentLookupPolicy(ArtifactClassLoader parentClassLoader) {
        if (!this.usesCustomDomain) {
            return super.getParentLookupPolicy(parentClassLoader);
        }
        HashMap<String, LookupStrategy> lookupStrategies = new HashMap<String, LookupStrategy>();
        DomainDescriptor descriptor = (DomainDescriptor)parentClassLoader.getArtifactDescriptor();
        descriptor.getClassLoaderConfiguration().getExportedPackages().forEach(p -> lookupStrategies.put((String)p, ParentFirstLookupStrategy.PARENT_FIRST));
        for (ArtifactPluginDescriptor artifactPluginDescriptor : descriptor.getPlugins()) {
            artifactPluginDescriptor.getClassLoaderConfiguration().getExportedPackages().forEach(p -> lookupStrategies.put((String)p, ParentFirstLookupStrategy.PARENT_FIRST));
        }
        return parentClassLoader.getClassLoaderLookupPolicy().extend(lookupStrategies);
    }

    @Override
    protected ArtifactClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    @Override
    protected RegionClassLoader createRegionClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, ClassLoader parentClassLoader, ClassLoaderLookupPolicy parentLookupPolicy) {
        return ToolingRegionClassLoader.newToolingRegionClassLoader(artifactId, artifactDescriptor, parentClassLoader, parentLookupPolicy);
    }

    public static String getApplicationId(String applicationName) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)applicationName), "applicationName cannot be empty");
        return "tooling-application/" + applicationName;
    }

    public static String getApplicationId(String applicationName, String domainId) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)applicationName), "applicationName cannot be empty");
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)domainId), "domainId  cannot be empty");
        return domainId + "tooling-application/" + applicationName;
    }
}

