/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.util.Objects;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.internal.connection.CompositeConnectionManager;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.DelegateConnectionManagerAdapter;
import org.mule.runtime.core.internal.util.func.CheckedConsumer;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactoryUtils;

public class ConnectionManagerConfigurationBuilder
implements ConfigurationBuilder {
    private final CheckedConsumer<MuleContext> muleContextConfigurer;

    ConnectionManagerConfigurationBuilder(DeployableArtifact parentArtifact) {
        Objects.requireNonNull(parentArtifact, "'parentArtifact' can't be null");
        this.muleContextConfigurer = muleContext -> ArtifactFactoryUtils.withArtifactMuleContext(parentArtifact, parentContext -> {
            if (ArtifactFactoryUtils.isConfigLess(parentArtifact)) {
                this.registerDefaultConnectionManager((MuleContext)muleContext);
            } else {
                ConnectionManagerAdapter parentConnectionManager = (ConnectionManagerAdapter)LegacyRegistryUtils.lookupObject(parentContext, "_muleConnectionManager");
                if (parentConnectionManager != null) {
                    CompositeConnectionManager connectionManager = new CompositeConnectionManager(new DelegateConnectionManagerAdapter((MuleContext)muleContext), parentConnectionManager);
                    this.registerConnectionManager((MuleContext)muleContext, connectionManager);
                } else {
                    this.registerDefaultConnectionManager((MuleContext)muleContext);
                }
            }
        });
    }

    ConnectionManagerConfigurationBuilder() {
        this.muleContextConfigurer = this::registerDefaultConnectionManager;
    }

    @Override
    public void configure(MuleContext muleContext) throws ConfigurationException {
        try {
            this.muleContextConfigurer.acceptChecked(muleContext);
        }
        catch (Throwable e) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage("An error occurred trying to register the Mule Connection Manager"), e);
        }
    }

    private void registerDefaultConnectionManager(MuleContext muleContext) {
        this.registerConnectionManager(muleContext, new DelegateConnectionManagerAdapter(muleContext));
    }

    private void registerConnectionManager(MuleContext muleContext, ConnectionManager connectionManager) {
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleConnectionManager", connectionManager);
    }

    @Override
    public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
    }
}

