/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.runtime.resolver;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;

@NoInstantiate
@NoExtend
public class ResolverSet
implements ValueResolver<ResolverSetResult>,
Initialisable {
    private final Map<String, ValueResolver<?>> resolvers = new LinkedHashMap();
    private boolean dynamic = false;
    private final Injector injector;

    @Deprecated(since="4.11", forRemoval=true)
    public ResolverSet(MuleContext muleContext) {
        this(muleContext.getInjector());
    }

    public ResolverSet(Injector injector) {
        this.injector = injector;
    }

    public ResolverSet add(String key, ValueResolver resolver) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)key), "A key for a ValueResolver cannot be blank");
        Objects.requireNonNull(resolver, "Resolver cannot be null");
        if (this.resolvers.put(key, resolver) != null) {
            throw new IllegalStateException("A value was already given for key " + key);
        }
        if (!this.dynamic && resolver.isDynamic()) {
            this.dynamic = true;
        }
        return this;
    }

    public ResolverSet addAll(Map<String, ValueResolver<?>> resolvers) {
        Objects.requireNonNull(resolvers, "Resolvers to be added cannot be null");
        resolvers.forEach(this::add);
        return this;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public ResolverSetResult resolve(ValueResolvingContext context) throws MuleException {
        ResolverSetResult.Builder builder = ResolverSetResult.newBuilder();
        boolean acceptsNullValues = context.acceptsNullValues();
        for (Map.Entry<String, ValueResolver<?>> entry : this.resolvers.entrySet()) {
            Object value = this.resolve(entry, context);
            if (value == null && !acceptsNullValues) continue;
            builder.add(entry.getKey(), value);
        }
        return builder.build();
    }

    protected Object resolve(Map.Entry<String, ValueResolver<?>> entry, ValueResolvingContext valueResolvingContext) throws MuleException {
        return ResolverUtils.resolveRecursively(entry.getValue(), valueResolvingContext);
    }

    public ResolverSet merge(ResolverSet resolverSet) {
        ResolverSet newResolverSet = new ResolverSet(this.injector);
        newResolverSet.addAll(this.resolvers);
        newResolverSet.addAll(resolverSet.getResolvers());
        return newResolverSet;
    }

    public Map<String, ValueResolver<?>> getResolvers() {
        return new HashMap(this.resolvers);
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.resolvers.values(), this.injector);
    }

    public String toString() {
        return (this.dynamic ? "(dynamic)" : "") + String.valueOf(this.resolvers);
    }
}

