/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.exception.EnrichedErrorMapping;
import org.mule.runtime.core.internal.exception.ErrorMappingsAware;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.MessagingException;

public final class InternalExceptionUtils {
    private InternalExceptionUtils() {
    }

    public static CoreEvent createErrorEvent(CoreEvent currentEvent, Component obj, MessagingException me, ErrorTypeLocator locator) {
        Throwable cause = me.getCause() != null ? me.getCause() : me;
        List<Object> errorMappings = Collections.emptyList();
        if (obj instanceof ErrorMappingsAware) {
            errorMappings = ((ErrorMappingsAware)obj).getErrorMappings();
        }
        if (!errorMappings.isEmpty() || InternalExceptionUtils.isMessagingExceptionCause(me, cause)) {
            Error newError = InternalExceptionUtils.getErrorFromFailingProcessor(me.getExceptionInfo().getErrorType(), obj, cause, locator);
            CoreEvent newEvent = EventQuickCopy.quickCopy(newError, me.getEvent());
            me.setProcessedEvent(newEvent);
            return newEvent;
        }
        return currentEvent;
    }

    private static boolean isMessagingExceptionCause(MessagingException me, Throwable cause) {
        return !me.getEvent().getError().filter(error -> cause.equals(error.getCause())).filter(error -> me.causedExactlyBy(error.getCause().getClass())).isPresent();
    }

    public static Error getErrorFromFailingProcessor(ErrorType currentError, Component processor, Throwable cause, ErrorTypeLocator locator) {
        ErrorType errorType;
        ErrorType foundErrorType = locator.lookupErrorType(cause);
        ErrorType resultError = InternalExceptionUtils.isUnknownMuleError(foundErrorType) ? currentError : foundErrorType;
        ErrorType errorTypeLookedUp = processor.getIdentifier() != null ? locator.lookupComponentErrorType(processor.getIdentifier(), cause) : foundErrorType;
        ErrorType errorType2 = errorType = InternalExceptionUtils.isUnknownMuleError(errorTypeLookedUp) && resultError != null ? resultError : errorTypeLookedUp;
        if (processor instanceof ErrorMappingsAware) {
            List<EnrichedErrorMapping> errorMappings = ((ErrorMappingsAware)processor).getErrorMappings();
            if (errorMappings.isEmpty()) {
                return ErrorBuilder.builder(cause).errorType(errorType).build();
            }
            return ErrorBuilder.builder(cause).errorType(errorMappings.stream().filter(m -> m.match(resultError == null || InternalExceptionUtils.isUnknownMuleError(resultError) ? errorType : currentError)).findFirst().map(EnrichedErrorMapping::getTarget).orElse(errorType)).build();
        }
        return ErrorBuilder.builder(cause).errorType(errorType).build();
    }

    public static boolean isUnknownMuleError(ErrorType type) {
        return type.getNamespace().equals(Errors.CORE_NAMESPACE_NAME) && type.getIdentifier().equals("UNKNOWN");
    }
}

