/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.simple;

import jakarta.inject.Inject;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.streaming.StreamingUtils;
import org.mule.runtime.core.internal.util.attribute.AttributeEvaluator;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.simple.SimpleMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddFlowVariableProcessor
extends SimpleMessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddFlowVariableProcessor.class);
    private ExtendedExpressionManager expressionManager;
    private AttributeEvaluator identifierEvaluator;
    private String value;
    private AttributeEvaluator valueEvaluator;
    private Optional<DataType> returnType = Optional.empty();
    private StreamingManager streamingManager;
    @Inject
    FeatureFlaggingService featureFlaggingService;
    private ArtifactEncoding artifactEncoding;

    @Override
    public void initialise() throws InitialisationException {
        this.identifierEvaluator.initialize(this.expressionManager);
        this.valueEvaluator = new AttributeEvaluator(this.value, this.getReturnDataType());
        this.valueEvaluator.initialize(this.expressionManager);
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        String key = (String)this.identifierEvaluator.resolveValue(event);
        if (key == null) {
            LOGGER.error("Setting Null variable keys is not supported, this entry is being ignored");
            return event;
        }
        TypedValue typedValue = this.valueEvaluator.resolveTypedValue(event);
        if (!this.featureFlaggingService.isEnabled(MuleRuntimeFeature.SET_VARIABLE_WITH_NULL_VALUE) && typedValue.getValue() == null) {
            LOGGER.debug("Variable with key '{}', not found on message using '{}'. Since the value was marked optional, nothing was set on the message for this variable", (Object)key, (Object)this.valueEvaluator.getRawValue());
            return this.removeProperty((PrivilegedEvent)event, key);
        }
        if (typedValue.getValue() != null) {
            typedValue = this.handleStreaming(typedValue, event, this.streamingManager);
        }
        return this.addProperty((PrivilegedEvent)event, key, typedValue.getValue(), DataType.builder().type(typedValue.getDataType().getType()).mediaType(this.getMediaType(typedValue)).charset(this.resolveEncoding(typedValue)).build());
    }

    private MediaType getMediaType(TypedValue<?> typedValue) {
        if (this.returnType.isPresent()) {
            return this.getReturnDataType().getMediaType();
        }
        return typedValue.getDataType().getMediaType();
    }

    protected Charset resolveEncoding(Object src) {
        return this.getReturnDataType().getMediaType().getCharset().orElse(this.getEncoding(src));
    }

    private Charset getEncoding(Object src) {
        if (src instanceof Message) {
            Message message = (Message)src;
            return message.getPayload().getDataType().getMediaType().getCharset().orElse(this.artifactEncoding.getDefaultEncoding());
        }
        return this.artifactEncoding.getDefaultEncoding();
    }

    protected PrivilegedEvent addProperty(PrivilegedEvent event, String propertyName, Object value, DataType dataType) {
        return PrivilegedEvent.builder(event).addVariable(propertyName, value, dataType).build();
    }

    protected PrivilegedEvent removeProperty(PrivilegedEvent event, String propertyName) {
        return PrivilegedEvent.builder(event).removeVariable(propertyName).build();
    }

    protected <T> TypedValue<T> handleStreaming(TypedValue<T> typedValue, CoreEvent event, StreamingManager streamingManager) {
        return StreamingUtils.updateTypedValueForStreaming(typedValue, event, streamingManager);
    }

    public void setIdentifier(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            throw new IllegalArgumentException("Key cannot be blank");
        }
        this.identifierEvaluator = new AttributeEvaluator(identifier, DataType.STRING);
    }

    public void setValue(String value) {
        Objects.requireNonNull(value);
        this.value = value;
    }

    public void setReturnDataType(DataType type) {
        this.returnType = Optional.of(type);
    }

    public DataType getReturnDataType() {
        return this.returnType.orElse(DataType.OBJECT);
    }

    @Inject
    public void setStreamingManager(StreamingManager streamingManager) {
        this.streamingManager = streamingManager;
    }

    @Inject
    public void setExpressionManager(ExtendedExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    @Inject
    public void setArtifactEncoding(ArtifactEncoding artifactEncoding) {
        this.artifactEncoding = artifactEncoding;
    }
}

