/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.ActingParameterModelParser;
import org.mule.runtime.extension.api.loader.parser.FieldValueProviderModelParser;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.ParameterModelParser;
import org.mule.runtime.extension.api.loader.parser.ValueProviderModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.extension.api.model.parameter.ImmutableActingParameterModel;
import org.mule.runtime.extension.api.property.ExcludeFromConnectivitySchemaModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.loader.delegate.StereotypeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldsValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.utils.FieldValueProviderNameUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ParameterModelsLoaderDelegate {
    private final Supplier<StereotypeModelLoaderDelegate> stereotypeModelLoader;
    private final Consumer<MetadataType> typeRegisterer;

    public ParameterModelsLoaderDelegate(Supplier<StereotypeModelLoaderDelegate> stereotypeModelLoader, Consumer<MetadataType> typeRegisterer) {
        this.stereotypeModelLoader = stereotypeModelLoader;
        this.typeRegisterer = typeRegisterer;
    }

    public List<ParameterDeclarer<?>> declare(HasParametersDeclarer component, List<ParameterGroupModelParser> groupParsers, ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext context) {
        LinkedList declarerList = new LinkedList();
        LazyValue<Supplier<Map>> containerParameterNames = new LazyValue<Supplier<Map>>(() -> this.getContainerParameterNames(groupParsers));
        groupParsers.forEach(group -> {
            ParameterGroupDeclarer groupDeclarer;
            if ("General".equals(group.getName())) {
                groupDeclarer = component.onDefaultParameterGroup();
            } else {
                groupDeclarer = component.onParameterGroup(group.getName()).withDslInlineRepresentation(group.showsInDsl());
                group.getDisplayModel().ifPresent(groupDeclarer::withDisplayModel);
                group.getLayoutModel().ifPresent(groupDeclarer::withLayout);
                group.getAdditionalModelProperties().forEach(groupDeclarer::withModelProperty);
                ((ParameterGroupDeclaration)groupDeclarer.getDeclaration()).setDescription(group.getDescription());
                group.getLayoutModel().ifPresent(groupDeclarer::withLayout);
            }
            group.getExclusiveOptionals().ifPresent(descriptor -> groupDeclarer.withExclusiveOptionals(descriptor.getExclusiveOptionals(), descriptor.isOneRequired()));
            group.getParameterParsers().forEach(arg_0 -> this.lambda$declare$2(groupDeclarer, group, (Supplier)containerParameterNames, extensionDeclarer, context, declarerList, arg_0));
            if (declarerList.stream().noneMatch(p -> p.getDeclaration().isComponentId())) {
                declarerList.stream().filter(p -> p.getDeclaration().getName().equals("name") && p.getDeclaration().isRequired() && p.getDeclaration().getExpressionSupport() == ExpressionSupport.NOT_SUPPORTED && p.getDeclaration().getType() instanceof StringType && p.getDeclaration().getAllowedStereotypeModels().isEmpty()).forEach(ParameterDeclarer::asComponentId);
            }
        });
        return declarerList;
    }

    private void declareValueProviders(ParameterGroupModelParser group, ParameterModelParser parameterParser, ParameterDeclarer<?> parameter, Supplier<Map<String, String>> containerParameterNames) {
        parameterParser.getValueProviderModelParser().ifPresent(valueProviderModelParser -> {
            List<ActingParameterModel> actingParameterModels = this.getActingParameterModels((ValueProviderModelParser)valueProviderModelParser, (Map)containerParameterNames.get());
            String vpName = valueProviderModelParser.getPartOrder().isPresent() ? group.getName() : parameterParser.getName();
            parameter.withValueProviderModel(this.createValueProviderModelFromParser(vpName, (ValueProviderModelParser)valueProviderModelParser, actingParameterModels));
            parameter.withModelProperty(new ValueProviderFactoryModelProperty(valueProviderModelParser.getValueProviderFactory(), actingParameterModels));
        });
    }

    private void declareFieldValueProviders(ParameterModelParser parameterParser, ParameterDeclarer<?> parameter, Supplier<Map<String, String>> containerParameterNames) {
        LinkedHashMap<String, ValueProviderFactoryModelProperty> fieldValueProviderFactoriesBySelector = new LinkedHashMap<String, ValueProviderFactoryModelProperty>();
        ArrayList<FieldValueProviderModel> fieldValueProviderModels = new ArrayList<FieldValueProviderModel>();
        parameterParser.getFieldValueProvidersModelParser().forEach(fieldValuesParser -> {
            List<ActingParameterModel> actingParameterModels = this.getActingParameterModels((ValueProviderModelParser)fieldValuesParser, (Map)containerParameterNames.get());
            fieldValueProviderModels.addAll(this.createValueProviderModelsFromParser(parameterParser.getName(), (FieldValueProviderModelParser)fieldValuesParser, actingParameterModels));
            ValueProviderFactoryModelProperty factoryMP = new ValueProviderFactoryModelProperty(fieldValuesParser.getValueProviderFactory(), actingParameterModels);
            fieldValuesParser.getTargetSelectors().forEach(targetSelector -> fieldValueProviderFactoriesBySelector.put((String)targetSelector, factoryMP));
        });
        if (!fieldValueProviderModels.isEmpty()) {
            parameter.withFieldValueProviderModels(fieldValueProviderModels);
        }
        if (!fieldValueProviderFactoriesBySelector.isEmpty()) {
            parameter.withModelProperty(new FieldsValueProviderFactoryModelProperty(fieldValueProviderFactoriesBySelector));
        }
    }

    private Map<String, String> getContainerParameterNames(List<ParameterGroupModelParser> groupParsers) {
        return groupParsers.stream().flatMap(gp -> gp.getParameterParsers().stream()).collect(Collectors.toMap(IntrospectionUtils::getImplementingName, ParameterModelParser::getName));
    }

    private ValueProviderModel createValueProviderModelFromParser(String valueProviderName, ValueProviderModelParser valueProviderModelParser, List<ActingParameterModel> actingParameterModels) {
        return new ValueProviderModel(actingParameterModels, valueProviderModelParser.requiresConfiguration(), valueProviderModelParser.requiresConnection(), valueProviderModelParser.isOpen(), valueProviderModelParser.getPartOrder().orElse(1), valueProviderName, valueProviderModelParser.getId(), valueProviderModelParser.getAdditionalModelProperties().toArray(new ModelProperty[0]));
    }

    private List<FieldValueProviderModel> createValueProviderModelsFromParser(String valueProviderName, FieldValueProviderModelParser valueProviderModelParser, List<ActingParameterModel> actingParameterModels) {
        ArrayList<FieldValueProviderModel> fieldValueProviderModels = new ArrayList<FieldValueProviderModel>();
        int partOrder = 1;
        valueProviderName = FieldValueProviderNameUtils.getFieldValueProviderName(valueProviderName, valueProviderModelParser.getTargetSelectors().toArray(new String[0]));
        for (String targetSelector : valueProviderModelParser.getTargetSelectors()) {
            fieldValueProviderModels.add(new FieldValueProviderModel(actingParameterModels, valueProviderModelParser.requiresConfiguration(), valueProviderModelParser.requiresConnection(), valueProviderModelParser.isOpen(), (Integer)partOrder++, valueProviderName, valueProviderModelParser.getId(), targetSelector));
        }
        return fieldValueProviderModels;
    }

    private List<ActingParameterModel> getActingParameterModels(ValueProviderModelParser valueProviderModelParser, Map<String, String> containerParameterNames) {
        return valueProviderModelParser.getActingParameterParsers().stream().map(parameterParser -> this.getActingParameterModel((ActingParameterModelParser)parameterParser, containerParameterNames)).toList();
    }

    private ActingParameterModel getActingParameterModel(ActingParameterModelParser actingParameterModelParser, Map<String, String> containerParameterNames) {
        if (actingParameterModelParser.getExtractionExpression().isPresent()) {
            return new ImmutableActingParameterModel(actingParameterModelParser.getParameterName(), actingParameterModelParser.isRequired(), actingParameterModelParser.getExtractionExpression().get());
        }
        String aliasedName = containerParameterNames.get(actingParameterModelParser.getParameterName());
        return new ImmutableActingParameterModel(aliasedName, actingParameterModelParser.isRequired(), aliasedName);
    }

    private MetadataKeyPartModelProperty createMetadataKeyPartModelProperty(Pair<Integer, Boolean> metadataKeyPart) {
        return new MetadataKeyPartModelProperty(metadataKeyPart.getFirst(), metadataKeyPart.getSecond());
    }

    private /* synthetic */ void lambda$declare$2(ParameterGroupDeclarer groupDeclarer, ParameterGroupModelParser group, Supplier containerParameterNames, ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext context, List declarerList, ParameterModelParser parameterParser) {
        ParameterDeclarer parameter = parameterParser.isRequired() ? groupDeclarer.withRequiredParameter(parameterParser.getName()) : groupDeclarer.withOptionalParameter(parameterParser.getName()).defaultingTo(parameterParser.getDefaultValue());
        parameterParser.getMetadataKeyPart().map(this::createMetadataKeyPartModelProperty).ifPresent(parameter::withModelProperty);
        Optional<InputResolverModelParser> inputResolverModelParser = parameterParser.getInputResolverModelParser();
        MetadataType metadataType = parameterParser.getType();
        if (inputResolverModelParser.isPresent()) {
            parameter.ofDynamicType(metadataType);
        } else {
            parameter.ofType(metadataType);
        }
        ((ParameterDeclarer)((ParameterDeclarer)parameter.describedAs(parameterParser.getDescription())).withRole(parameterParser.getRole())).withExpressionSupport(parameterParser.getExpressionSupport());
        this.typeRegisterer.accept(metadataType);
        if (parameterParser.isComponentId()) {
            parameter.asComponentId();
        }
        if (parameterParser.isConfigOverride()) {
            parameter.asConfigOverride();
        }
        this.declareValueProviders(group, parameterParser, parameter, containerParameterNames);
        this.declareFieldValueProviders(parameterParser, parameter, containerParameterNames);
        if (parameterParser.isExcludedFromConnectivitySchema()) {
            parameter.withModelProperty(new ExcludeFromConnectivitySchemaModelProperty());
        }
        parameterParser.getLayoutModel().ifPresent(parameter::withLayout);
        parameterParser.getDslConfiguration().ifPresent(parameter::withDsl);
        parameterParser.getDeprecationModel().ifPresent(parameter::withDeprecation);
        parameterParser.getDisplayModel().ifPresent(parameter::withDisplayModel);
        parameterParser.getOAuthParameterModelProperty().ifPresent(parameter::withModelProperty);
        parameterParser.getAdditionalModelProperties().forEach(parameter::withModelProperty);
        MinMuleVersionUtils.declareWithBaselineMmv(parameterParser::getResolvedMinMuleVersion, parameter, ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getMinMuleVersion(), context);
        ModelLoaderUtils.addSemanticTerms(parameter.getDeclaration(), parameterParser);
        this.stereotypeModelLoader.get().addStereotypes(parameterParser, parameter);
        declarerList.add(parameter);
    }
}

