/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.entity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;

public interface HttpEntity {
    public boolean isStreaming();

    @Deprecated(since="4.10", forRemoval=true)
    default public boolean isComposed() {
        return false;
    }

    public InputStream getContent();

    public byte[] getBytes() throws IOException;

    @Deprecated(since="4.10", forRemoval=true)
    default public Collection<HttpPart> getParts() throws IOException {
        return Collections.emptyList();
    }

    @Deprecated
    public Optional<Long> getLength();

    default public OptionalLong getBytesLength() {
        return this.getLength().map(l -> OptionalLong.of(l)).orElse(OptionalLong.empty());
    }

    default public void onComplete(BiConsumer<? super MultiMap<String, String>, ? super Throwable> completionCallback) {
        completionCallback.accept(MultiMap.emptyMultiMap(), null);
    }
}

