/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;

public final class ReconnectionStrategyDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        if (ComponentDeclarationUtils.isReconnectionStrategySupported(declaration)) {
            return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){

                @Override
                protected void onSource(SourceDeclaration declaration) {
                    this.addReconnectionIfRequired(declaration);
                }

                @Override
                protected void onOperation(OperationDeclaration declaration) {
                    this.addReconnectionIfRequired(declaration);
                }

                private void addReconnectionIfRequired(ExecutableComponentDeclaration<?> declaration) {
                    if (declaration.isRequiresConnection() && ComponentDeclarationUtils.isReconnectionStrategySupported(declaration)) {
                        InfrastructureParameterBuilder.addReconnectionStrategyParameter(declaration);
                    }
                }
            });
        }
        return Optional.empty();
    }
}

