/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue.wrapper;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.queue.DefaultQueueConfiguration;
import org.mule.runtime.api.queue.QueueManager;
import org.mule.runtime.core.internal.util.queue.wrapper.QueueSessionSdkWrapper;
import org.mule.sdk.api.queue.QueueConfiguration;
import org.mule.sdk.api.queue.QueueSession;

public class QueueManagerSdkWrapper
implements org.mule.sdk.api.queue.QueueManager {
    private QueueManager delegate;

    @Inject
    @Named(value="_muleApiQueueManager")
    public void setQueueManager(QueueManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public QueueSession getQueueSession() {
        return new QueueSessionSdkWrapper(this.delegate.getQueueSession());
    }

    @Override
    public Optional<QueueConfiguration> getQueueConfiguration(String queueName) {
        return this.delegate.getQueueConfiguration(queueName).map(QueueConfig::new);
    }

    @Override
    public void configureQueue(String queueName, int maxOutstandingMessages, boolean persistent) {
        this.delegate.setQueueConfiguration(queueName, new DefaultQueueConfiguration(maxOutstandingMessages, persistent));
    }

    private static final class QueueConfig
    implements QueueConfiguration {
        private final org.mule.runtime.api.queue.QueueConfiguration config;

        public QueueConfig(org.mule.runtime.api.queue.QueueConfiguration config) {
            this.config = config;
        }

        @Override
        public boolean isPersistent() {
            return this.config.isPersistent();
        }

        @Override
        public int getCapacity() {
            return this.config.getCapacity();
        }
    }
}

