/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.message;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.OptionalLong;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.support.internal.message.muletosdk.HttpEntityWrapper;
import org.mule.sdk.api.http.domain.entity.HttpEntity;
import org.mule.sdk.api.http.domain.entity.HttpEntityFactory;

public class HttpEntityFactoryImpl
implements HttpEntityFactory {
    @Override
    public HttpEntity from(byte[] content) {
        return new HttpEntityWrapper(new ByteArrayHttpEntity(content));
    }

    @Override
    public HttpEntity from(String content, Charset charset) {
        return new HttpEntityWrapper(new ByteArrayHttpEntity(content.getBytes(charset)));
    }

    @Override
    public HttpEntity from(InputStream content) {
        return new HttpEntityWrapper(new InputStreamHttpEntity(content));
    }

    @Override
    public HttpEntity from(InputStream inputStream, Long contentLength) {
        return new HttpEntityWrapper(new InputStreamHttpEntity(inputStream, contentLength == null ? OptionalLong.empty() : OptionalLong.of(contentLength)));
    }

    @Override
    public HttpEntity emptyEntity() {
        return new HttpEntityWrapper(new EmptyHttpEntity());
    }
}

