/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.ConfigurationModelParser;
import org.mule.runtime.extension.api.loader.parser.ExtensionModelParser;
import org.mule.runtime.extension.api.property.NoImplicitModelProperty;
import org.mule.runtime.module.extension.internal.loader.delegate.AbstractComponentModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;

final class ConfigModelLoaderDelegate
extends AbstractComponentModelLoaderDelegate {
    ConfigModelLoaderDelegate(DefaultExtensionModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareConfigurations(ExtensionDeclarer declarer, ExtensionModelParser extensionModelParser, ExtensionLoadingContext context) {
        for (ConfigurationModelParser configParser : extensionModelParser.getConfigurationParsers()) {
            String configName = this.resolveConfigName(configParser);
            ConfigurationDeclarer configurationDeclarer = declarer.withConfig(configName).describedAs(this.resolveConfigDescription(configParser, configName)).withModelProperty(new ConfigurationFactoryModelProperty(configParser.getConfigurationFactory()));
            if (configParser.isForceNoImplicit()) {
                configurationDeclarer.withModelProperty(new NoImplicitModelProperty());
            }
            configParser.getDeprecationModel().ifPresent(dm -> ((ConfigurationDeclaration)configurationDeclarer.getDeclaration()).withDeprecation((DeprecationModel)dm));
            configParser.getDisplayModel().ifPresent(d -> ((ConfigurationDeclaration)configurationDeclarer.getDeclaration()).setDisplayModel((DisplayModel)d));
            configParser.getExternalLibraryModels().forEach(configurationDeclarer::withExternalLibrary);
            configParser.getAdditionalModelProperties().forEach(configurationDeclarer::withModelProperty);
            MinMuleVersionUtils.declareWithBaselineMmv(configParser::getResolvedMinMuleVersion, configurationDeclarer, ((ExtensionDeclaration)declarer.getDeclaration()).getMinMuleVersion(), context);
            this.loader.getParameterModelsLoaderDelegate().declare(configurationDeclarer, configParser.getParameterGroupParsers(), declarer, context);
            this.getOperationLoaderDelegate().declareOperations(declarer, extensionModelParser.getDevelopmentFramework(), configurationDeclarer, configParser.getOperationParsers(), context);
            this.getSourceModelLoaderDelegate().declareMessageSources(declarer, configurationDeclarer, configParser.getSourceModelParsers(), context);
            this.getFunctionModelLoaderDelegate().declareFunctions(declarer, configParser.getFunctionModelParsers(), context);
            this.getConnectionProviderModelLoaderDelegate().declareConnectionProviders(configurationDeclarer, configParser.getConnectionProviderModelParsers(), declarer, context);
            this.getStereotypeModelLoaderDelegate().addStereotypes(configParser, configurationDeclarer, Optional.of(() -> this.getStereotypeModelLoaderDelegate().getDefaultConfigStereotype(configParser.getName())));
        }
    }

    private String resolveConfigName(ConfigurationModelParser parser) {
        return StringUtils.isBlank((CharSequence)parser.getName()) ? "config" : parser.getName();
    }

    private String resolveConfigDescription(ConfigurationModelParser parser, String configName) {
        String description = parser.getDescription();
        if (StringUtils.isBlank((CharSequence)description) && "config".equals(configName)) {
            description = "Default configuration";
        }
        return description;
    }
}

