/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.maven.pom.parser.api.model.PomParentCoordinates;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.maven.MavenUtils;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedBundleDescriptorAttributes;
import org.mule.tools.api.classloader.AppClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public class MavenBundleDescriptorLoader
implements BundleDescriptorLoader {
    private static final String CLASSLOADER_MODEL_JSON_DESCRIPTOR = "classloader-model.json";
    private static final String CLASSLOADER_MODEL_JSON_DESCRIPTOR_LOCATION = "META-INF/mule-artifact/classloader-model.json";
    private static final String JAR = "jar";

    @Override
    public String getId() {
        return "mule";
    }

    @Override
    public BundleDescriptor load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        File classLoaderModelDescriptor = this.getClassLoaderModelDescriptor(artifactFile);
        if (classLoaderModelDescriptor.exists()) {
            ClassLoaderModel packagerClassLoaderModel = ArtifactType.APP.equals((Object)artifactType) || ArtifactType.DOMAIN.equals((Object)artifactType) || ArtifactType.POLICY.equals((Object)artifactType) ? AppClassLoaderModelJsonSerializer.deserialize(classLoaderModelDescriptor) : ClassLoaderModelJsonSerializer.deserialize(classLoaderModelDescriptor);
            return new BundleDescriptor.Builder().setArtifactId(packagerClassLoaderModel.getArtifactCoordinates().getArtifactId()).setGroupId(packagerClassLoaderModel.getArtifactCoordinates().getGroupId()).setVersion(packagerClassLoaderModel.getArtifactCoordinates().getVersion()).setBaseVersion(packagerClassLoaderModel.getArtifactCoordinates().getVersion()).setType(packagerClassLoaderModel.getArtifactCoordinates().getType()).setClassifier(packagerClassLoaderModel.getArtifactCoordinates().getClassifier()).setMetadata(Collections.singletonMap(ClassLoaderModel.class.getName(), packagerClassLoaderModel)).build();
        }
        if (attributes instanceof PluginExtendedBundleDescriptorAttributes) {
            return ((PluginExtendedBundleDescriptorAttributes)attributes).getPluginBundleDescriptor();
        }
        return this.getBundleDescriptor(artifactFile, artifactType);
    }

    private BundleDescriptor getBundleDescriptor(File artifactFile, ArtifactType artifactType) {
        BundleDescriptor.Builder builder = new BundleDescriptor.Builder();
        if (artifactType.equals((Object)ArtifactType.APP) || artifactType.equals((Object)ArtifactType.DOMAIN)) {
            Properties pomProperties = artifactFile.isDirectory() ? MavenUtils.getPomPropertiesFolder(artifactFile) : MavenUtils.getPomPropertiesFromJar(artifactFile);
            String version = pomProperties.getProperty("version");
            return builder.setGroupId(pomProperties.getProperty("groupId")).setArtifactId(pomProperties.getProperty("artifactId")).setVersion(version).setBaseVersion(version).setClassifier(artifactType.getMavenArtifactClassifier()).build();
        }
        MavenPomModel model = MavenPomParserProvider.discoverProvider().createMavenPomParserClient(artifactFile.toPath()).getModel();
        String version = model.getVersion() != null ? model.getVersion() : (String)model.getParent().map(PomParentCoordinates::getVersion).orElse(null);
        return new BundleDescriptor.Builder().setArtifactId(model.getArtifactId()).setGroupId(model.getGroupId() != null ? model.getGroupId() : (String)model.getParent().map(PomParentCoordinates::getGroupId).orElse(null)).setVersion(version).setBaseVersion(version).setType(JAR).setClassifier(artifactType.equals((Object)ArtifactType.PLUGIN) ? ArtifactType.PLUGIN.getMavenArtifactClassifier() : model.getPackaging()).build();
    }

    protected File getClassLoaderModelDescriptor(File artifactFile) {
        if (artifactFile.isDirectory()) {
            return new File(artifactFile, CLASSLOADER_MODEL_JSON_DESCRIPTOR_LOCATION);
        }
        return new File(artifactFile.getParent(), CLASSLOADER_MODEL_JSON_DESCRIPTOR);
    }
}

