/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.properties.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.runtime.properties.api.DefaultConfigurationPropertiesProviderFactory;
import org.mule.runtime.properties.api.InitialisableConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurationPropertiesProvider
extends AbstractComponent
implements ConfigurationPropertiesProvider,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfigurationPropertiesProvider.class);
    private final InitialisableConfigurationPropertiesProvider provider;
    protected Map<String, ConfigurationProperty> configurationAttributes = new HashMap<String, ConfigurationProperty>();
    protected static final String UNKNOWN = "unknown";
    protected final String fileLocation;
    private final ResourceProvider resourceProvider;

    public DefaultConfigurationPropertiesProvider(String fileLocation, String encoding, ResourceProvider resourceProvider) {
        this.fileLocation = fileLocation;
        this.resourceProvider = resourceProvider;
        DefaultConfigurationPropertiesProviderFactory factory = this.discoverProviderFactory();
        this.provider = factory.createProvider(fileLocation, encoding, resourceProvider, this);
    }

    public DefaultConfigurationPropertiesProvider(String fileLocation, ResourceProvider resourceProvider) {
        this(fileLocation, null, resourceProvider);
    }

    public Optional<ConfigurationProperty> provide(String configurationAttributeKey) {
        return this.provider.provide(configurationAttributeKey);
    }

    @Override
    public String getDescription() {
        return this.provider.getDescription();
    }

    @Override
    public void initialise() throws InitialisationException {
        this.provider.initialise();
        this.configurationAttributes = this.provider.getConfigurationAttributes();
    }

    public String toString() {
        return this.getDescription();
    }

    private DefaultConfigurationPropertiesProviderFactory discoverProviderFactory() {
        ServiceLoader<DefaultConfigurationPropertiesProviderFactory> loader = ServiceLoader.load(DefaultConfigurationPropertiesProviderFactory.class, DefaultConfigurationPropertiesProviderFactory.class.getClassLoader());
        Iterator<DefaultConfigurationPropertiesProviderFactory> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException(String.format("Could not find %s service implementation through SPI", DefaultConfigurationPropertiesProviderFactory.class.getName()));
        }
        DefaultConfigurationPropertiesProviderFactory factory = iterator.next();
        if (iterator.hasNext()) {
            LOGGER.debug(String.format("Found more than one %s service implementation through SPI", DefaultConfigurationPropertiesProviderFactory.class.getName()));
        }
        return factory;
    }

    public String createValueHelper(String key, String value) {
        return this.createValue(key, value);
    }

    protected InputStream getResourceInputStream(String file) throws IOException {
        return this.resourceProvider.getResourceAsStream(file);
    }

    protected String createValue(String key, String value) {
        return value;
    }
}

