/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.container.internal.splash.ArtifactShutdownSplashScreen;
import org.mule.runtime.container.internal.splash.ServerShutdownSplashScreen;
import org.mule.runtime.container.internal.splash.SplashScreen;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

final class SplashScreenConfigurationBuilder
implements ConfigurationBuilder {
    private static final Logger SPLASH_LOGGER = LoggerFactory.getLogger((String)"org.mule.runtime.core.internal.logging");
    private final Level splashScrenLevel;

    public SplashScreenConfigurationBuilder(Level splashScrenLevel) {
        this.splashScrenLevel = splashScrenLevel;
    }

    @Override
    public void configure(MuleContext muleContext) throws ConfigurationException {
        if (muleContext instanceof DefaultMuleContext) {
            DefaultMuleContext dmc = (DefaultMuleContext)muleContext;
            dmc.addListener(new MuleContextListener(){

                @Override
                public void onStart(MuleContext context, Registry registry) {
                    if (SPLASH_LOGGER.isEnabledForLevel(SplashScreenConfigurationBuilder.this.splashScrenLevel)) {
                        SplashScreen startupScreen = SplashScreenConfigurationBuilder.this.buildStartupSplash(context);
                        SPLASH_LOGGER.atLevel(SplashScreenConfigurationBuilder.this.splashScrenLevel).log(startupScreen.toString());
                    }
                }

                @Override
                public void onStop(MuleContext context, Registry registry) {
                    if (context.getStartDate() > 0L && SPLASH_LOGGER.isEnabledForLevel(SplashScreenConfigurationBuilder.this.splashScrenLevel)) {
                        SplashScreen shutdownScreen = SplashScreenConfigurationBuilder.this.buildShutdownSplash(context);
                        SPLASH_LOGGER.atLevel(SplashScreenConfigurationBuilder.this.splashScrenLevel).log(shutdownScreen.toString());
                    }
                }

                @Override
                public void onInitialization(MuleContext context, Registry registry) {
                }

                @Override
                public void onCreation(MuleContext context) {
                }
            });
        }
    }

    SplashScreen buildStartupSplash(MuleContext muleContext) {
        SplashScreen startupScreen = this.createSplashScreen(muleContext);
        startupScreen.setHeader(muleContext);
        startupScreen.setFooter(muleContext);
        return startupScreen;
    }

    SplashScreen buildShutdownSplash(MuleContext muleContext) {
        SplashScreen shutdownScreen = this.createSplashScreen(muleContext);
        shutdownScreen.setHeader(muleContext);
        return shutdownScreen;
    }

    private SplashScreen createSplashScreen(MuleContext muleContext) {
        return muleContext.getConfiguration().isContainerMode() ? new ArtifactShutdownSplashScreen() : new ServerShutdownSplashScreen();
    }

    @Override
    public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
    }
}

