/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.ParameterModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.metadata.JavaInputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.JavaMetadataTypeResolverUtils;
import org.mule.runtime.module.extension.internal.metadata.chain.PassThroughChainInputTypeResolver;
import org.mule.sdk.api.annotation.metadata.ChainInputResolver;
import org.mule.sdk.api.annotation.metadata.PassThroughInputChainResolver;
import org.mule.sdk.api.annotation.metadata.TypeResolver;
import org.mule.sdk.api.metadata.resolving.ChainInputTypeResolver;

public class JavaInputResolverModelParserUtils {
    public static List<InputResolverModelParser> parseInputResolversModelParser(List<ParameterGroupModelParser> parameterGroupModelParsers) {
        return parameterGroupModelParsers.stream().flatMap(parameterGroup -> parameterGroup.getParameterParsers().stream()).map(ParameterModelParser::getInputResolverModelParser).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static Optional<InputResolverModelParser> getResolverParser(ExtensionParameter extensionParameter) {
        Optional<Type> type = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(extensionParameter, "parameter", extensionParameter.getName(), org.mule.runtime.extension.api.annotation.metadata.TypeResolver.class, TypeResolver.class, value -> value.getClassValue(org.mule.runtime.extension.api.annotation.metadata.TypeResolver::value), value -> value.getClassValue(TypeResolver::value));
        return type.flatMap(t -> JavaInputResolverModelParserUtils.getJavaInputResolverParser(extensionParameter.getName(), t));
    }

    public static Optional<ChainInputTypeResolver> getChainInputTypeResolver(ExtensionParameter chain) {
        Optional<ChainInputTypeResolver> resolver = chain.getValueFromAnnotation(PassThroughInputChainResolver.class).map(a -> PassThroughChainInputTypeResolver.INSTANCE);
        if (!resolver.isPresent()) {
            resolver = chain.getValueFromAnnotation(ChainInputResolver.class).flatMap(a -> a.getClassValue(ChainInputResolver::value).getDeclaringClass()).map(type -> {
                try {
                    return (ChainInputTypeResolver)type.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalModelDefinitionException(String.format("Non instantiable %s type: %s", ChainInputTypeResolver.class.getSimpleName(), type.getName()), e);
                }
            });
        }
        return resolver;
    }

    private static Optional<InputResolverModelParser> getJavaInputResolverParser(String parameterName, Type type) {
        if (!type.getDeclaringClass().isPresent()) {
            return Optional.empty();
        }
        Class<?> resolverClazz = type.getDeclaringClass().get();
        if (JavaMetadataTypeResolverUtils.isStaticResolver(resolverClazz)) {
            return Optional.empty();
        }
        return Optional.of(new JavaInputResolverModelParser(parameterName, resolverClazz));
    }
}

