/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.el.ModuleNamespace;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.internal.el.CompositeExpressionModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBindingContextBuilder
implements BindingContext.Builder {
    private TypedValue payloadBinding;
    private TypedValue attributesBinding;
    private Optional<Supplier<TypedValue>> varsBinding = Optional.empty();
    private Optional<Supplier<TypedValue>> paramsBinding = Optional.empty();
    private TypedValue errorBinding;
    private TypedValue correlationIdBinding;
    private TypedValue authenticationBinding;
    private TypedValue itemSequenceInfoBinding;
    private boolean bindingAdded = false;
    private LinkedList<BindingContext> delegates = null;
    private Map<String, Supplier<TypedValue>> bindings = null;
    private Collection<ExpressionModule> modules = null;

    public DefaultBindingContextBuilder() {
    }

    public DefaultBindingContextBuilder(BindingContext bindingContext) {
        this.delegates = new LinkedList();
        this.delegates.add(bindingContext);
        this.payloadBinding = bindingContext.lookup("payload").orElse(null);
        this.attributesBinding = bindingContext.lookup("attributes").orElse(null);
        this.varsBinding = bindingContext.lookup("vars").flatMap(vars -> Optional.of(() -> vars));
        this.paramsBinding = bindingContext.lookup("params").flatMap(params -> Optional.of(() -> params));
        this.errorBinding = bindingContext.lookup("error").orElse(null);
        this.correlationIdBinding = bindingContext.lookup("correlationId").orElse(null);
        this.authenticationBinding = bindingContext.lookup("authentication").orElse(null);
        this.itemSequenceInfoBinding = bindingContext.lookup("itemSequenceInfo").orElse(null);
    }

    @Override
    public BindingContext.Builder addBinding(String identifier, TypedValue value) {
        this.bindingAdded = true;
        switch (identifier) {
            case "payload": {
                this.payloadBinding = value;
                break;
            }
            case "attributes": {
                this.attributesBinding = value;
                break;
            }
            case "vars": {
                this.varsBinding = Optional.of(() -> value);
                break;
            }
            case "params": {
                this.paramsBinding = Optional.of(() -> value);
                break;
            }
            case "error": {
                this.errorBinding = value;
                break;
            }
            case "correlationId": {
                this.correlationIdBinding = value;
                break;
            }
            case "authentication": {
                this.authenticationBinding = value;
                break;
            }
            case "itemSequenceInfo": {
                this.itemSequenceInfoBinding = value;
                break;
            }
            default: {
                if (this.bindings == null) {
                    this.bindings = new SmallMap<String, Supplier<TypedValue>>();
                }
                this.bindings.put(identifier, () -> value);
            }
        }
        return this;
    }

    @Override
    public BindingContext.Builder addBinding(String identifier, Supplier<TypedValue> lazyValue) {
        this.bindingAdded = true;
        switch (identifier) {
            case "payload": {
                this.payloadBinding = lazyValue.get();
                break;
            }
            case "attributes": {
                this.attributesBinding = lazyValue.get();
                break;
            }
            case "vars": {
                this.varsBinding = Optional.of(lazyValue);
                break;
            }
            case "params": {
                this.paramsBinding = Optional.of(lazyValue);
                break;
            }
            case "error": {
                this.errorBinding = lazyValue.get();
                break;
            }
            case "correlationId": {
                this.correlationIdBinding = lazyValue.get();
                break;
            }
            case "authentication": {
                this.authenticationBinding = lazyValue.get();
                break;
            }
            case "itemSequenceInfo": {
                this.itemSequenceInfoBinding = lazyValue.get();
                break;
            }
            default: {
                if (this.bindings == null) {
                    this.bindings = new SmallMap<String, Supplier<TypedValue>>();
                }
                this.bindings.put(identifier, lazyValue);
            }
        }
        return this;
    }

    @Override
    public BindingContext.Builder addAll(BindingContext context) {
        if (this.delegates == null) {
            this.delegates = new LinkedList();
        }
        if (this.bindingAdded) {
            this.delegates.addFirst(new BindingContextImplementation(Collections.emptyList(), this.bindings == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.bindings), this.payloadBinding, this.attributesBinding, this.varsBinding, this.paramsBinding, this.errorBinding, this.correlationIdBinding, this.authenticationBinding, this.itemSequenceInfoBinding, this.modules != null ? Collections.unmodifiableCollection(this.modules) : Collections.emptyList()));
            this.payloadBinding = null;
            this.attributesBinding = null;
            this.varsBinding = Optional.empty();
            this.paramsBinding = Optional.empty();
            this.errorBinding = null;
            this.correlationIdBinding = null;
            this.authenticationBinding = null;
            this.itemSequenceInfoBinding = null;
            this.bindings = null;
            this.modules = null;
            this.bindingAdded = false;
        }
        this.payloadBinding = context.lookup("payload").orElse(this.payloadBinding);
        this.attributesBinding = context.lookup("attributes").orElse(this.attributesBinding);
        context.lookup("vars").ifPresent(vars -> {
            this.varsBinding = Optional.of(() -> vars);
        });
        context.lookup("params").ifPresent(params -> {
            this.paramsBinding = Optional.of(() -> params);
        });
        this.errorBinding = context.lookup("error").orElse(this.errorBinding);
        this.correlationIdBinding = context.lookup("correlationId").orElse(this.correlationIdBinding);
        this.authenticationBinding = context.lookup("authentication").orElse(this.authenticationBinding);
        this.itemSequenceInfoBinding = context.lookup("itemSequenceInfo").orElse(this.itemSequenceInfoBinding);
        this.delegates.addFirst(context);
        return this;
    }

    @Override
    public BindingContext.Builder addModule(ExpressionModule expressionModule) {
        this.bindingAdded = true;
        if (this.modules == null) {
            this.modules = new ArrayList<ExpressionModule>();
        }
        this.modules.add(expressionModule);
        return this;
    }

    @Override
    public BindingContext build() {
        return new BindingContextImplementation(this.delegates == null || this.delegates.isEmpty() ? Collections.emptyList() : new ArrayList<BindingContext>(this.delegates), this.bindings == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.bindings), this.payloadBinding, this.attributesBinding, this.varsBinding, this.paramsBinding, this.errorBinding, this.correlationIdBinding, this.authenticationBinding, this.itemSequenceInfoBinding, this.modules != null ? Collections.unmodifiableCollection(this.modules) : Collections.emptyList());
    }

    public BindingContext flattenAndBuild() {
        BindingContext original = this.build();
        HashMap<String, Supplier<TypedValue>> flattenedBindings = new HashMap<String, Supplier<TypedValue>>();
        for (Binding binding : original.bindings()) {
            if (flattenedBindings.containsKey(binding.identifier()) || "payload".equals(binding.identifier()) || "attributes".equals(binding.identifier()) || "vars".equals(binding.identifier()) || "params".equals(binding.identifier()) || "error".equals(binding.identifier()) || "correlationId".equals(binding.identifier()) || "authentication".equals(binding.identifier()) || "itemSequenceInfo".equals(binding.identifier())) continue;
            flattenedBindings.put(binding.identifier(), () -> binding.value());
        }
        return new BindingContextImplementation(Collections.emptyList(), flattenedBindings, original.lookup("payload").orElse(null), original.lookup("attributes").orElse(null), Optional.of(() -> original.lookup("vars").orElse(null)), Optional.of(() -> original.lookup("params").orElse(null)), original.lookup("error").orElse(null), original.lookup("correlationId").orElse(null), original.lookup("authentication").orElse(null), original.lookup("itemSequenceInfo").orElse(null), original.modules());
    }

    public static class BindingContextImplementation
    implements BindingContext {
        private static final Logger LOGGER = LoggerFactory.getLogger(BindingContextImplementation.class);
        private final List<BindingContext> delegates;
        private final Optional<TypedValue> payloadBinding;
        private final Optional<TypedValue> attributesBinding;
        private final Supplier<TypedValue> varsBinding;
        private final Supplier<TypedValue> paramsBinding;
        private final Optional<TypedValue> errorBinding;
        private final Optional<TypedValue> correlationIdBinding;
        private final Optional<TypedValue> authenticationBinding;
        private final Optional<TypedValue> itemSequenceInfoBinding;
        private final Map<String, Supplier<TypedValue>> bindings;
        private final Collection<ExpressionModule> modules;

        private BindingContextImplementation(List<BindingContext> delegates, Map<String, Supplier<TypedValue>> bindings, TypedValue payloadBinding, TypedValue attributesBinding, Optional<Supplier<TypedValue>> varsBinding, Optional<Supplier<TypedValue>> paramsBinding, TypedValue errorBinding, TypedValue correlationIdBinding, TypedValue authenticationBinding, TypedValue itemSequenceInfoBinding, Collection<ExpressionModule> modules) {
            this.delegates = delegates;
            this.bindings = bindings;
            this.payloadBinding = Optional.ofNullable(payloadBinding);
            this.attributesBinding = Optional.ofNullable(attributesBinding);
            this.varsBinding = varsBinding.orElse(() -> null);
            this.paramsBinding = paramsBinding.orElse(() -> null);
            this.errorBinding = Optional.ofNullable(errorBinding);
            this.correlationIdBinding = Optional.ofNullable(correlationIdBinding);
            this.authenticationBinding = Optional.ofNullable(authenticationBinding);
            this.itemSequenceInfoBinding = Optional.ofNullable(itemSequenceInfoBinding);
            this.modules = modules;
        }

        private Optional<TypedValue> lookUpInDelegates(String identifier) {
            for (BindingContext bindingContext : this.delegates) {
                Optional<TypedValue> result = bindingContext.lookup(identifier);
                if (!result.isPresent()) continue;
                return result;
            }
            return Optional.empty();
        }

        @Override
        public Collection<Binding> bindings() {
            TypedValue params;
            HashMap<String, Binding> bindingsMap = new HashMap<String, Binding>();
            for (Map.Entry<String, Supplier<TypedValue>> entry : this.bindings.entrySet()) {
                bindingsMap.put(entry.getKey(), new Binding(entry.getKey(), entry.getValue() != null ? entry.getValue().get() : null));
            }
            this.payloadBinding.ifPresent(pb -> bindingsMap.put("payload", new Binding("payload", (TypedValue)pb)));
            this.attributesBinding.ifPresent(ab -> bindingsMap.put("attributes", new Binding("attributes", (TypedValue)ab)));
            TypedValue vars = this.varsBinding.get();
            if (vars != null) {
                bindingsMap.put("vars", new Binding("vars", vars));
            }
            if ((params = this.paramsBinding.get()) != null) {
                bindingsMap.put("params", new Binding("params", params));
            }
            this.errorBinding.ifPresent(eb -> bindingsMap.put("error", new Binding("error", (TypedValue)eb)));
            this.correlationIdBinding.ifPresent(cidb -> bindingsMap.put("correlationId", new Binding("correlationId", (TypedValue)cidb)));
            this.authenticationBinding.ifPresent(ab -> bindingsMap.put("authentication", new Binding("authentication", (TypedValue)ab)));
            this.itemSequenceInfoBinding.ifPresent(isib -> bindingsMap.put("itemSequenceInfo", new Binding("itemSequenceInfo", (TypedValue)isib)));
            for (BindingContext bindingContext : this.delegates) {
                for (Binding binding : bindingContext.bindings()) {
                    bindingsMap.putIfAbsent(binding.identifier(), binding);
                }
            }
            return bindingsMap.values();
        }

        @Override
        public Collection<String> identifiers() {
            HashSet<String> identifiers = new HashSet<String>(this.bindings.keySet());
            this.payloadBinding.ifPresent(pb -> identifiers.add("payload"));
            this.attributesBinding.ifPresent(pb -> identifiers.add("attributes"));
            if (this.varsBinding.get() != null) {
                identifiers.add("vars");
            }
            if (this.paramsBinding.get() != null) {
                identifiers.add("params");
            }
            this.errorBinding.ifPresent(pb -> identifiers.add("error"));
            this.correlationIdBinding.ifPresent(pb -> identifiers.add("correlationId"));
            this.authenticationBinding.ifPresent(pb -> identifiers.add("authentication"));
            this.itemSequenceInfoBinding.ifPresent(pb -> identifiers.add("itemSequenceInfo"));
            for (BindingContext bindingContext : this.delegates) {
                identifiers.addAll(bindingContext.identifiers());
            }
            return identifiers;
        }

        @Override
        public Optional<TypedValue> lookup(String identifier) {
            switch (identifier) {
                case "payload": {
                    return this.payloadBinding;
                }
                case "attributes": {
                    return this.attributesBinding;
                }
                case "vars": {
                    return Optional.ofNullable(this.varsBinding.get());
                }
                case "params": {
                    return Optional.ofNullable(this.paramsBinding.get());
                }
                case "error": {
                    return this.errorBinding;
                }
                case "correlationId": {
                    return this.correlationIdBinding;
                }
                case "authentication": {
                    return this.authenticationBinding;
                }
                case "itemSequenceInfo": {
                    return this.itemSequenceInfoBinding;
                }
            }
            Supplier<TypedValue> supplier = this.bindings.get(identifier);
            return supplier != null ? Optional.ofNullable(supplier.get()) : this.lookUpInDelegates(identifier);
        }

        @Override
        public Collection<ExpressionModule> modules() {
            HashMap<ModuleNamespace, ExpressionModule> modulesByNamespace = new HashMap<ModuleNamespace, ExpressionModule>();
            for (ExpressionModule module : this.modules) {
                BindingContextImplementation.addOrMerge(modulesByNamespace, module);
            }
            for (BindingContext bindingContext : this.delegates) {
                for (ExpressionModule module : bindingContext.modules()) {
                    BindingContextImplementation.addOrMerge(modulesByNamespace, module);
                }
            }
            return modulesByNamespace.values();
        }

        private static void addOrMerge(Map<ModuleNamespace, ExpressionModule> modulesByNamespace, ExpressionModule module) {
            ModuleNamespace namespace = module.namespace();
            if (modulesByNamespace.containsKey(namespace)) {
                BindingContextImplementation.reportRepeatedNamespace(namespace);
                modulesByNamespace.put(namespace, new CompositeExpressionModule(module, modulesByNamespace.get(namespace)));
            } else {
                modulesByNamespace.put(namespace, module);
            }
        }

        private static void reportRepeatedNamespace(ModuleNamespace namespace) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Two modules with namespace '{}' were found in a binding context. We're merging them into a single one in order to make the expression language able to use the content of both, but the maintainer of such module should review this situation.\nIt may happen when an extension with types or functions also declares a GlobalBindingContextProvider that adds a ExpressionModule to the resulting BindingContext. If that's the case,the provider should be removed and the types/functions should be added to the extension model.", (Object)namespace);
            } else {
                LOGGER.warn("Two modules with namespace '{}' were found in a binding context. Set log level to DEBUG for details", (Object)namespace);
            }
        }
    }
}

