/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.container.internal.splash.SplashScreen;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.internal.context.ArtifactStoppedPersistenceListener;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeploymentStopException;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DisposableClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeployableArtifact<D extends DeployableArtifactDescriptor>
implements DeployableArtifact<D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDeployableArtifact.class);
    private static final Logger SPLASH_LOGGER = LoggerFactory.getLogger((String)"org.mule.runtime.core.internal.logging");
    protected final String shortArtifactType;
    protected final String artifactType;
    protected ArtifactContext artifactContext;
    protected ArtifactClassLoader deploymentClassLoader;
    protected static final String START = "start";
    protected static final String STOP = "stop";

    public AbstractDeployableArtifact(String shortArtifactType, String artifactType, ArtifactClassLoader deploymentClassLoader) {
        this.artifactType = artifactType;
        this.shortArtifactType = shortArtifactType;
        this.deploymentClassLoader = Objects.requireNonNull(deploymentClassLoader, "Classloader cannot be null");
    }

    @Override
    public final void stop() {
        if (this.getArtifactContext() != null && this.getArtifactContext().getRegistry() != null) {
            for (Flow flow : this.getArtifactContext().getRegistry().lookupAllByType(Flow.class)) {
                ((DefaultFlowBuilder.DefaultFlow)flow).doNotPersist();
            }
        }
        if (this.artifactContext == null || !this.artifactContext.getMuleContext().getLifecycleManager().isDirectTransition(STOP)) {
            if (SPLASH_LOGGER.isInfoEnabled()) {
                SPLASH_LOGGER.info(String.format("Stopping %s '%s' with no mule context", this.shortArtifactType, this.getArtifactName()));
            }
            return;
        }
        this.artifactContext.getMuleContext().getLifecycleManager().checkPhase(STOP);
        ClassUtils.withContextClassLoader(null, () -> {
            if (SPLASH_LOGGER.isInfoEnabled()) {
                SPLASH_LOGGER.info(SplashScreen.miniSplash(String.format("Stopping %s '%s'", this.artifactType, this.getArtifactName())));
            }
        });
        ClassUtils.withContextClassLoader(this.deploymentClassLoader.getClassLoader(), () -> {
            this.artifactContext.getMuleContext().stop();
            this.persistArtifactState(STOP);
            return null;
        });
    }

    @Override
    public final void dispose() {
        ClassUtils.withContextClassLoader(null, () -> SPLASH_LOGGER.info(SplashScreen.miniSplash(String.format("Disposing %s '%s'", this.artifactType, this.getArtifactName()))));
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader artifactCL = null;
            if (this.getArtifactClassLoader() != null) {
                artifactCL = this.getArtifactClassLoader().getClassLoader();
            }
            if (artifactCL != null) {
                Thread.currentThread().setContextClassLoader(artifactCL);
            }
            this.doDispose();
            if (artifactCL != null && artifactCL instanceof DisposableClassLoader) {
                ((DisposableClassLoader)((Object)artifactCL)).dispose();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            this.deploymentClassLoader = null;
        }
    }

    private void doDispose() {
        if (this.artifactContext == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("%s '%s' never started, nothing to dispose of", StringUtils.capitalize((String)this.artifactType), this.getArtifactName()));
            }
            return;
        }
        try {
            this.stop();
        }
        catch (DeploymentStopException e) {
            LOGGER.error(String.format("Error stopping %s '%s'", this.artifactType, this.getArtifactName()), (Throwable)e);
        }
        this.artifactContext.getMuleContext().dispose();
        this.artifactContext = null;
    }

    protected void persistArtifactState(String state) {
        ArtifactStoppedPersistenceListener artifactStoppedPersistenceListener = (ArtifactStoppedPersistenceListener)((MuleContextWithRegistry)this.artifactContext.getMuleContext()).getRegistry().lookupObject("artifactStoppedPersistenceListener");
        if (artifactStoppedPersistenceListener != null && state.equals(START)) {
            artifactStoppedPersistenceListener.onStart();
        } else if (artifactStoppedPersistenceListener != null && state.equals(STOP)) {
            artifactStoppedPersistenceListener.onStop();
        }
    }

    @Override
    public ArtifactContext getArtifactContext() {
        return this.artifactContext;
    }
}

