/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.internal.xml.StaticXmlNamespaceInfo;
import org.mule.runtime.ast.internal.xml.StaticXmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfo;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;

public class XmlNamespaceInfoProviderSupplier {
    public static List<XmlNamespaceInfoProvider> createFromExtensionModels(Set<ExtensionModel> extensionModels) {
        ArrayList<XmlNamespaceInfoProvider> providers = new ArrayList<XmlNamespaceInfoProvider>();
        providers.add(XmlNamespaceInfoProviderSupplier.createStaticNamespaceInfoProviders(extensionModels));
        providers.addAll(XmlNamespaceInfoProviderSupplier.discoverRuntimeXmlNamespaceInfoProvider());
        providers.addAll(XmlNamespaceInfoProviderSupplier.discoverArtifactNamespaceInfoProvider());
        return Collections.unmodifiableList(providers);
    }

    private static List<XmlNamespaceInfoProvider> discoverArtifactNamespaceInfoProvider() {
        return XmlNamespaceInfoProvider.loadXmlNamespaceInfoProviders(Thread.currentThread().getContextClassLoader()).collect(Collectors.toList());
    }

    private static List<XmlNamespaceInfoProvider> discoverRuntimeXmlNamespaceInfoProvider() {
        return XmlNamespaceInfoProvider.loadXmlNamespaceInfoProviders().collect(Collectors.toList());
    }

    private static XmlNamespaceInfoProvider createStaticNamespaceInfoProviders(Set<ExtensionModel> extensionModels) {
        List<XmlNamespaceInfo> extensionNamespaces = Collections.unmodifiableList(extensionModels.stream().map(ext -> new StaticXmlNamespaceInfo(ext.getXmlDslModel().getNamespace(), ext.getXmlDslModel().getPrefix())).collect(Collectors.toList()));
        return new StaticXmlNamespaceInfoProvider(extensionNamespaces);
    }
}

