/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.el;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.config.MuleConfiguration;

@NoInstantiate
public class DataWeaveArtifactContext {
    private final MuleConfiguration configuration;
    private final Registry registry;

    public DataWeaveArtifactContext(MuleConfiguration configuration, Registry registry) {
        this.configuration = configuration;
        this.registry = registry;
    }

    public String getName() {
        return this.configuration.getId();
    }

    public String getWorkDir() {
        return this.configuration.getWorkingDirectory();
    }

    public String getEncoding() {
        return this.configuration.getDefaultEncoding();
    }

    public boolean isStandalone() {
        return this.configuration.isStandalone();
    }

    public Map<String, Object> getRegistry() {
        return new RegistryWrapperMap(this.registry);
    }

    protected static class RegistryWrapperMap
    implements Map<String, Object> {
        private final Registry registry;

        public RegistryWrapperMap(Registry registry) {
            this.registry = registry;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Registry does not support clear");
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Object get(Object key) {
            if (!(key instanceof String)) {
                return null;
            }
            Object value = null;
            try {
                value = this.registry.lookupByName((String)key).orElse(null);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return value;
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException("Registry does not support put");
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("Registry does not support remove");
        }

        @Override
        public Collection<Object> values() {
            ArrayList<Object> values = new ArrayList<Object>(this.size());
            for (String key : this.keySet()) {
                values.add(this.get(key));
            }
            return values;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>();
            for (String key : this.keySet()) {
                entrySet.add(new AbstractMap.SimpleEntry<String, Object>(key, this.get(key)));
            }
            return entrySet;
        }

        @Override
        public boolean containsValue(Object value) {
            for (String key : this.keySet()) {
                if (!value.equals(this.get(key))) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException("Registry does not support keySet");
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("Registry does not support size");
        }
    }
}

