/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.xml.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.dsl.api.xml.parser.ConfigLineProvider;
import org.mule.runtime.dsl.api.xml.parser.SimpleConfigAttribute;

@Deprecated
@NoExtend
@NoInstantiate
public final class ConfigLine {
    private ConfigLineProvider parent;
    private String namespace;
    private String namespaceUri;
    private String identifier;
    private final Map<String, SimpleConfigAttribute> configAttributes = new HashMap<String, SimpleConfigAttribute>();
    private final Map<String, Object> customAttributes = new HashMap<String, Object>();
    private final List<ConfigLine> childrenConfigLines = new LinkedList<ConfigLine>();
    private int lineNumber;
    private String textContent;
    private int startColumn;
    private String sourceCode;

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Map<String, SimpleConfigAttribute> getConfigAttributes() {
        return Collections.unmodifiableMap(new HashMap<String, SimpleConfigAttribute>(this.configAttributes));
    }

    public Map<String, Object> getCustomAttributes() {
        return Collections.unmodifiableMap(this.customAttributes);
    }

    public List<ConfigLine> getChildren() {
        return this.childrenConfigLines;
    }

    @Deprecated
    public ConfigLine getParent() {
        return this.parent.getConfigLine();
    }

    public String getTextContent() {
        return this.textContent;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigLine that = (ConfigLine)o;
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        if (!this.configAttributes.equals(that.configAttributes)) {
            return false;
        }
        return this.childrenConfigLines.equals(that.childrenConfigLines);
    }

    public int hashCode() {
        int result = this.namespace != null ? this.namespace.hashCode() : 0;
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + this.configAttributes.hashCode();
        result = 31 * result + this.childrenConfigLines.hashCode();
        return result;
    }

    public static class Builder {
        public static final String BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT = "builder already build an object, you cannot modify it";
        private final ConfigLine configLine = new ConfigLine();
        private boolean alreadyBuild;

        public Builder setNamespace(String namespace) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.namespace = namespace;
            return this;
        }

        public Builder setNamespaceUri(String namespaceUri) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.namespaceUri = namespaceUri;
            return this;
        }

        public Builder setIdentifier(String operation) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.identifier = operation;
            return this;
        }

        public Builder setLineNumber(int lineNumber) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.lineNumber = lineNumber;
            return this;
        }

        public Builder setStartColumn(int startColumn) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.startColumn = startColumn;
            return this;
        }

        public Builder addConfigAttribute(String name, String value, boolean valueFromSchema) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.configAttributes.put(name, new SimpleConfigAttribute(name, value, valueFromSchema));
            return this;
        }

        public Builder addCustomAttribute(String name, Object value) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.customAttributes.put(name, value);
            return this;
        }

        public Builder addChild(ConfigLine line) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.childrenConfigLines.add(line);
            return this;
        }

        @Deprecated
        public Builder setParent(ConfigLineProvider parent) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.parent = parent;
            return this;
        }

        public Builder setTextContent(String textContent) {
            this.configLine.textContent = textContent;
            return this;
        }

        public Builder setSourceCode(String sourceCode) {
            this.configLine.sourceCode = sourceCode;
            return this;
        }

        public ConfigLine build() {
            this.alreadyBuild = true;
            return this.configLine;
        }
    }
}

