/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue.wrapper;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.queue.DefaultQueueConfiguration;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.util.queue.TransactionalQueueManager;
import org.mule.runtime.core.internal.util.queue.wrapper.QueueSessionWrapper;

public class LocalQueueManagerWrapper
implements QueueManager,
Initialisable,
Disposable {
    private TransactionalQueueManager delegate = new TransactionalQueueManager();

    @Inject
    public void setMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.delegate.setMuleConfiguration(muleConfiguration);
    }

    @Inject
    @Named(value="_muleDefaultObjectSerializer")
    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.delegate.setObjectSerializer(objectSerializer);
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.delegate.setMuleContext(muleContext);
    }

    @Override
    public QueueSession getQueueSession() {
        return new QueueSessionWrapper(this.delegate.getQueueSession());
    }

    @Override
    public void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.delegate.setDefaultQueueConfiguration(new DefaultQueueConfiguration(config.getCapacity(), config.isPersistent()));
    }

    @Override
    public void setQueueConfiguration(String queueName, QueueConfiguration config) {
        this.delegate.setQueueConfiguration(queueName, new DefaultQueueConfiguration(config.getCapacity(), config.isPersistent()));
    }

    @Override
    public Optional<QueueConfiguration> getQueueConfiguration(String queueName) {
        return this.delegate.getQueueConfiguration(queueName).map(config -> new org.mule.runtime.core.api.util.queue.DefaultQueueConfiguration(config.getCapacity(), config.isPersistent()));
    }

    @Override
    public void start() throws MuleException {
        this.delegate.start();
    }

    @Override
    public void stop() throws MuleException {
        this.delegate.stop();
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }

    @Override
    public void initialise() throws InitialisationException {
        this.delegate.initialise();
    }
}

