/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.StereotypedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithConstructsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.property.NoImplicitModelProperty;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.extension.internal.declaration.type.MetadataTypeConstants;
import org.mule.runtime.extension.internal.util.ExtensionNamespaceUtils;
import org.mule.sdk.api.stereotype.MuleStereotypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRefDeclarationEnricher
implements WalkingDeclarationEnricher {
    private final boolean isExpressionSupportEnabled = Boolean.getBoolean("mule.experimental.enableDynamicConfigRef");
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRefDeclarationEnricher.class);
    private static final String CONFIG_REF_NAME = "config-ref";

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(final ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate(){
            final ExtensionDeclaration declaration;
            final String namespace;
            final MultiMap<ComponentDeclaration, ConfigurationDeclaration> componentConfigs;
            {
                this.declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
                this.namespace = ExtensionNamespaceUtils.getExtensionsNamespace(this.declaration);
                this.componentConfigs = new MultiMap();
            }

            @Override
            public void onConfiguration(ConfigurationDeclaration config) {
                if (config.getStereotype() == null) {
                    config.withStereotype(StereotypeModelBuilder.newStereotype(config.getName(), this.namespace).withParent(MuleStereotypes.CONFIG).build());
                }
            }

            @Override
            public void onConstruct(WithConstructsDeclaration owner, ConstructDeclaration declaration) {
                this.collectComponent(declaration, owner);
            }

            @Override
            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                this.collectComponent(declaration, owner);
            }

            @Override
            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                this.collectComponent(declaration, owner);
            }

            @Override
            public void onWalkFinished() {
                this.componentConfigs.toListValuesMap().forEach((component, configs) -> {
                    if ("APIKit".equals(this.declaration.getName()) && component.getDefaultParameterGroup().getParameters().stream().anyMatch(param -> param.getName().equals(ConfigRefDeclarationEnricher.CONFIG_REF_NAME))) {
                        LOGGER.warn("Component '" + component.getName() + "' in extension '" + this.declaration.getName() + "' already has a '" + ConfigRefDeclarationEnricher.CONFIG_REF_NAME + "' parameter defined. Skipping ConfigRefDeclarationEnricher for it.");
                        return;
                    }
                    component.getDefaultParameterGroup().addParameter(ConfigRefDeclarationEnricher.this.buildConfigRefParameter(component, configs));
                });
            }

            private void collectComponent(ComponentDeclaration declaration, Object owner) {
                if (owner instanceof ConfigurationDeclaration) {
                    this.componentConfigs.put(declaration, (ConfigurationDeclaration)owner);
                }
            }
        });
    }

    private ParameterDeclaration buildConfigRefParameter(ComponentDeclaration componentDeclaration, Collection<ConfigurationDeclaration> configs) {
        ParameterDeclaration parameter = new ParameterDeclaration(CONFIG_REF_NAME);
        parameter.setDescription("The name of the configuration to be used to execute this component");
        parameter.setRequired(!this.hasAnImplicitConfig(configs));
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.addModelProperty(new SyntheticModelModelProperty());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsReferences(true).build());
        parameter.setType(MetadataTypeConstants.CONFIG_TYPE, false);
        parameter.setExpressionSupport(this.expressionSupport(componentDeclaration));
        parameter.setAllowedStereotypeModels(this.collectStereotypes(configs));
        return parameter;
    }

    private List<StereotypeModel> collectStereotypes(Collection<ConfigurationDeclaration> configs) {
        return configs.stream().map(StereotypedDeclaration::getStereotype).collect(Collectors.toList());
    }

    private boolean hasAnImplicitConfig(Collection<ConfigurationDeclaration> configs) {
        return configs.stream().filter(ConfigRefDeclarationEnricher::canBeUsedImplicitly).anyMatch(config -> {
            List<ConnectionProviderDeclaration> providers = config.getConnectionProviders();
            return providers.isEmpty() || providers.stream().anyMatch(ConfigRefDeclarationEnricher::canBeUsedImplicitly);
        });
    }

    static boolean canBeUsedImplicitly(ParameterizedDeclaration<?> parameterized) {
        if (parameterized.getModelProperty(NoImplicitModelProperty.class).isPresent()) {
            return false;
        }
        return parameterized.getAllParameters().stream().filter(p -> !p.isComponentId()).noneMatch(ParameterDeclaration::isRequired);
    }

    private ExpressionSupport expressionSupport(ComponentDeclaration<?> componentDeclaration) {
        return this.isExpressionSupportEnabled && componentDeclaration instanceof OperationDeclaration ? ExpressionSupport.SUPPORTED : ExpressionSupport.NOT_SUPPORTED;
    }
}

