/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.consumer;

import com.google.gson.Gson;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.core.internal.profiling.consumer.ComponentProfilingUtils;
import org.mule.runtime.core.internal.profiling.consumer.annotations.RuntimeInternalProfilingDataConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeInternalProfilingDataConsumer
public class TransactionLoggerDataConsumer
implements ProfilingDataConsumer<TransactionProfilingEventContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionLoggerDataConsumer.class);
    private final Gson gson = new Gson();

    @Override
    public void onProfilingEvent(ProfilingEventType<TransactionProfilingEventContext> profilingEventType, TransactionProfilingEventContext profilingEventContext) {
        Logger logger = this.getDataConsumerLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(this.gson.toJson(ComponentProfilingUtils.getTxInfo(profilingEventType, profilingEventContext)));
        }
    }

    @Override
    public Set<ProfilingEventType<TransactionProfilingEventContext>> getProfilingEventTypes() {
        return Set.of(RuntimeProfilingEventTypes.TX_START, RuntimeProfilingEventTypes.TX_COMMIT, RuntimeProfilingEventTypes.TX_CONTINUE, RuntimeProfilingEventTypes.TX_ROLLBACK);
    }

    @Override
    public Predicate<TransactionProfilingEventContext> getEventContextFilter() {
        return txCtx -> true;
    }

    protected Logger getDataConsumerLogger() {
        return LOGGER;
    }
}

