/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ParentOnlyLookupStrategy;

public class MuleClassLoaderLookupPolicy
implements ClassLoaderLookupPolicy {
    private static final String PACKAGE_SEPARATOR = ".";
    private final Map<String, LookupStrategy> configuredLookupStrategies;
    private final Set<String> rootSystemPackages;
    private final Map<String, LookupStrategy> lookupStrategies;

    public MuleClassLoaderLookupPolicy(Map<String, LookupStrategy> lookupStrategies, Set<String> rootSystemPackages) {
        Objects.requireNonNull(lookupStrategies, "Lookup strategies cannot be null");
        Objects.requireNonNull(rootSystemPackages, "System packages cannot be null");
        this.rootSystemPackages = this.normalizeRootSystemPackages(rootSystemPackages);
        this.configuredLookupStrategies = this.normalizeLookupStrategies(lookupStrategies);
        this.lookupStrategies = new HashMap<String, LookupStrategy>();
    }

    private Map<String, LookupStrategy> normalizeLookupStrategies(Map<String, LookupStrategy> lookupStrategies) {
        HashMap<String, LookupStrategy> result = new HashMap<String, LookupStrategy>();
        for (String packageName : lookupStrategies.keySet()) {
            result.put(this.normalizePackageName(packageName), lookupStrategies.get(packageName));
        }
        return result;
    }

    private void validateLookupPolicies(Map<String, LookupStrategy> lookupStrategies) {
        for (String packageName : lookupStrategies.keySet()) {
            this.validateLookupPolicy(packageName, lookupStrategies.get(packageName));
        }
    }

    private void validateLookupPolicy(String packageName, LookupStrategy lookupStrategy) {
        if (this.isSystemPackage(packageName) && !(lookupStrategy instanceof ContainerOnlyLookupStrategy)) {
            throw new IllegalArgumentException(MuleClassLoaderLookupPolicy.invalidLookupPolicyOverrideError(packageName, lookupStrategy));
        }
    }

    protected static String invalidLookupPolicyOverrideError(String packageName, LookupStrategy lookupStrategy) {
        return "Attempt to override lookup strategy " + lookupStrategy.getClass().getSimpleName() + " for package: " + packageName;
    }

    private String normalizePackageName(String packageName) {
        if (packageName.endsWith(PACKAGE_SEPARATOR)) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        return packageName;
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> normalizeRootSystemPackages(Set<String> rootSystemPackages) {
        HashSet<String> result = new HashSet<String>();
        for (String string : rootSystemPackages) {
            void var4_4;
            String string2 = string.trim();
            if (!string2.endsWith(PACKAGE_SEPARATOR)) {
                String string3 = string2 + PACKAGE_SEPARATOR;
            }
            result.add((String)var4_4);
        }
        return result;
    }

    @Override
    public LookupStrategy getClassLookupStrategy(String className) {
        return this.getPackageLookupStrategy(ClassUtils.getPackageName((String)className));
    }

    @Override
    public LookupStrategy getPackageLookupStrategy(String packageName) {
        return Objects.requireNonNullElseGet(this.configuredLookupStrategies.get(packageName), () -> {
            LookupStrategy lookupStrategy = this.lookupStrategies.get(packageName);
            if (lookupStrategy == null) {
                MuleClassLoaderLookupPolicy muleClassLoaderLookupPolicy = this;
                synchronized (muleClassLoaderLookupPolicy) {
                    lookupStrategy = this.lookupStrategies.get(packageName);
                    if (lookupStrategy == null) {
                        lookupStrategy = this.isSystemPackage(packageName) ? ParentOnlyLookupStrategy.PARENT_ONLY : ChildFirstLookupStrategy.CHILD_FIRST;
                        this.lookupStrategies.put(packageName, lookupStrategy);
                    }
                }
            }
            return lookupStrategy;
        });
    }

    @Override
    public ClassLoaderLookupPolicy extend(Map<String, LookupStrategy> lookupStrategies) {
        return this.extend(lookupStrategies, false);
    }

    @Override
    public ClassLoaderLookupPolicy extend(Stream<String> packages, LookupStrategy lookupStrategy) {
        return this.extend(packages, lookupStrategy, false);
    }

    @Override
    public ClassLoaderLookupPolicy extend(Map<String, LookupStrategy> lookupStrategies, boolean overwrite) {
        this.validateLookupPolicies(lookupStrategies);
        Map<String, LookupStrategy> newLookupStrategies = SmallMap.copy(this.configuredLookupStrategies);
        for (String packageName : lookupStrategies.keySet()) {
            if (!overwrite && newLookupStrategies.containsKey(this.normalizePackageName(packageName))) continue;
            newLookupStrategies.put(packageName, lookupStrategies.get(packageName));
        }
        MuleClassLoaderLookupPolicy muleClassLoaderLookupPolicy = new MuleClassLoaderLookupPolicy(newLookupStrategies, this.rootSystemPackages);
        return muleClassLoaderLookupPolicy;
    }

    @Override
    public ClassLoaderLookupPolicy extend(Stream<String> packages, LookupStrategy lookupStrategy, boolean overwrite) {
        Map<String, LookupStrategy> newLookupStrategies = SmallMap.copy(this.configuredLookupStrategies);
        packages.forEach(packageName -> {
            this.validateLookupPolicy((String)packageName, lookupStrategy);
            if (overwrite || !newLookupStrategies.containsKey(this.normalizePackageName((String)packageName))) {
                newLookupStrategies.put((String)packageName, lookupStrategy);
            }
        });
        MuleClassLoaderLookupPolicy muleClassLoaderLookupPolicy = new MuleClassLoaderLookupPolicy(newLookupStrategies, this.rootSystemPackages);
        return muleClassLoaderLookupPolicy;
    }

    private boolean isSystemPackage(String packageName) {
        return this.rootSystemPackages.contains(packageName + PACKAGE_SEPARATOR) || this.rootSystemPackages.contains(packageName);
    }

    public String toString() {
        return "MuleClassLoaderLookupPolicy{" + System.lineSeparator() + "\tconfiguredLookupStrategies: " + String.valueOf(this.configuredLookupStrategies) + System.lineSeparator() + "\trootSystemPackages: " + String.valueOf(this.rootSystemPackages) + System.lineSeparator() + "\tlookupStrategies: " + String.valueOf(this.lookupStrategies) + System.lineSeparator() + "}";
    }
}

