/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl.configuration;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.observability.AbstractFileObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfigurationFileFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOpenTelemetryLoggingConfiguration
extends AbstractFileObservabilitySignalConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FileOpenTelemetryLoggingConfiguration.class);
    private static final List<String> artifactLevelConfigurationProperties = List.of("mule.openTelemetry.logging.exporter.resource.service.name", "mule.openTelemetry.logging.exporter.resource.service.namespace");

    public FileOpenTelemetryLoggingConfiguration(ObservabilitySignalConfigurationFileFinder artifactResourceFinder, DeployableArtifactDescriptor deployableArtifactDescriptor) {
        super(artifactResourceFinder, deployableArtifactDescriptor);
    }

    @Override
    protected void onConfigurationFileNotFound() {
        logger.atInfo().log("Logging exporter configuration file named '{}' not found {}. Using default configuration.", (Object)this.getSignalConfigurationFileName(), (Object)this.getConfigurationFileLocations());
    }

    @Override
    protected void onConfigurationFileLoadError(Exception error, File configurationFile) {
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Parsing error in the logging exporter configuration file '%s'.", configurationFile.getAbsolutePath()), error));
    }

    @Override
    protected Path getSignalConfigurationFileDirectoryPath() {
        return Paths.get(System.getProperty("mule.openTelemetry.logging.exporter.configurationFilePath", MuleFoldersUtil.getConfFolder().getAbsolutePath()), new String[0]).toAbsolutePath();
    }

    @Override
    protected boolean isArtifactLevelProperty(String configurationKey) {
        return artifactLevelConfigurationProperties.contains(configurationKey);
    }

    @Override
    protected String getSignalConfigurationFileName() {
        return System.getProperty("mule.openTelemetry.logging.exporter.configurationFileName", "logging-exporter.conf");
    }
}

