/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.model;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeHandlerManagerFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.sdk.api.stereotype.MuleStereotypes;

public class DefaultExtensionModelHelper
implements ExtensionModelHelper {
    private final Set<ExtensionModel> extensionsModels;
    private final Cache<ComponentIdentifier, Optional<ComponentModel>> extensionComponentModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Cache<ComponentIdentifier, Optional<ConnectionProviderModel>> extensionConnectionProviderModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Cache<ComponentIdentifier, Optional<ConfigurationModel>> extensionConfigurationModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Optional<DslSyntaxResolver> muleTopLevelDslSyntaxResolver;
    private final LoadingCache<ExtensionModel, DslSyntaxResolver> dslSyntaxResolversByExtension;
    private final JavaTypeLoader javaTypeLoader = new JavaTypeLoader(MuleImplementationLoaderUtils.getMuleImplementationsLoader(), new ExtensionsTypeHandlerManagerFactory());
    private final DslResolvingContext dslResolvingContext;

    public DefaultExtensionModelHelper(Set<ExtensionModel> extensionModels) {
        this(extensionModels, DslResolvingContext.getDefault(extensionModels));
    }

    public DefaultExtensionModelHelper(Set<ExtensionModel> extensionModels, DslResolvingContext dslResolvingCtx) {
        this.extensionsModels = extensionModels;
        this.dslSyntaxResolversByExtension = Caffeine.newBuilder().build(key -> DslSyntaxResolver.getDefault(key, dslResolvingCtx));
        this.muleTopLevelDslSyntaxResolver = extensionModels.stream().filter(extModel -> extModel.getName().equals("mule")).map(arg_0 -> this.dslSyntaxResolversByExtension.get(arg_0)).findAny();
        this.dslResolvingContext = dslResolvingCtx;
    }

    @Override
    public TypedComponentIdentifier.ComponentType findComponentType(ComponentIdentifier componentIdentifier) {
        return this.findComponentModel(componentIdentifier).map(this::findComponentType).orElse(TypedComponentIdentifier.ComponentType.UNKNOWN);
    }

    @Override
    public TypedComponentIdentifier.ComponentType findComponentType(ComponentModel extensionComponentModel) {
        final Reference componentTypeReference = new Reference();
        extensionComponentModel.accept(new ComponentModelVisitor(){

            @Override
            public void visit(OperationModel model) {
                componentTypeReference.set(TypedComponentIdentifier.ComponentType.OPERATION);
                this.determineFromNested(componentTypeReference, model);
            }

            @Override
            public void visit(SourceModel model) {
                componentTypeReference.set(TypedComponentIdentifier.ComponentType.SOURCE);
            }

            @Override
            public void visit(ConstructModel model) {
                StereotypeModel st = model.getStereotype();
                if (st.equals(MuleStereotypes.ERROR_HANDLER)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
                    return;
                }
                if (st.equals(MuleStereotypes.ON_ERROR)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.ON_ERROR);
                    return;
                }
                if (st.equals(MuleStereotypes.FLOW)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.FLOW);
                    return;
                }
                if (st.equals(MuleStereotypes.SUB_FLOW)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.SUB_FLOW);
                    return;
                }
                if (st.equals(MuleStereotypes.CHAIN)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.CHAIN);
                    return;
                }
                if (st.equals(MuleStereotypes.OPERATION_DEF_STEREOTYPE)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.OPERATION_DEF);
                    return;
                }
                if (st.equals(MuleStereotypes.OUTPUT_PAYLOAD_STEREOTYPE)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.OUTPUT_PAYLOAD_TYPE);
                    return;
                }
                if (st.equals(MuleStereotypes.OUTPUT_ATTRIBUTES_STEREOTYPE)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.OUTPUT_ATTRIBUTES_TYPE);
                    return;
                }
                this.determineFromNested(componentTypeReference, model);
            }

            protected void determineFromNested(Reference<TypedComponentIdentifier.ComponentType> componentTypeReference2, ComposableModel model) {
                NestedComponentVisitor nestedComponentVisitor = new NestedComponentVisitor(componentTypeReference2);
                for (NestableElementModel nestableElementModel : model.getNestedComponents()) {
                    nestableElementModel.accept(nestedComponentVisitor);
                    if (componentTypeReference2.get() == null) continue;
                    return;
                }
            }

            @Override
            public void visit(NestedComponentModel model) {
                if (model.getAllowedStereotypes().contains(MuleStereotypes.ERROR_HANDLER)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
                }
            }

            @Override
            public void visit(NestedChainModel model) {
                componentTypeReference.set(TypedComponentIdentifier.ComponentType.CHAIN);
            }

            @Override
            public void visit(NestedRouteModel model) {
                if (MuleStereotypes.ON_ERROR.equals(model.getStereotype())) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.ON_ERROR);
                } else {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.ROUTE);
                }
            }
        });
        return componentTypeReference.get() == null ? TypedComponentIdentifier.ComponentType.UNKNOWN : (TypedComponentIdentifier.ComponentType)((Object)componentTypeReference.get());
    }

    @Override
    public Optional<ComponentModel> findComponentModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionComponentModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(extensionModel -> {
            AtomicReference modelRef = new AtomicReference();
            new IdempotentExtensionWalker((ExtensionModel)extensionModel, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$extensionModel;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$extensionModel = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = DefaultExtensionModelHelper.this.getDslSyntaxResolverFor(this.val$extensionModel);
                }

                @Override
                protected void onOperation(OperationModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, model);
                }

                @Override
                protected void onSource(SourceModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, model);
                }

                @Override
                protected void onConstruct(ConstructModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, model);
                }

                @Override
                protected void onNestable(NestableElementModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, model);
                }

                protected void onModel(ComponentIdentifier componentIdentifier, AtomicReference<ComponentModel> modelRef, ComponentModel model) {
                    if (this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                        modelRef.set(model);
                    }
                }
            }.walk((ExtensionModel)extensionModel);
            return Optional.ofNullable((ComponentModel)modelRef.get());
        }));
    }

    public Optional<ConnectionProviderModel> findConnectionProviderModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionConnectionProviderModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(currentExtension -> {
            AtomicReference modelRef = new AtomicReference();
            new IdempotentExtensionWalker((ExtensionModel)currentExtension, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$currentExtension;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$currentExtension = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = DefaultExtensionModelHelper.this.getDslSyntaxResolverFor(this.val$currentExtension);
                }

                @Override
                protected void onConnectionProvider(ConnectionProviderModel model) {
                    if (this.dslSyntaxResolver.resolve(model).getElementName().equals(this.val$componentIdentifier.getName())) {
                        this.val$modelRef.set(model);
                    }
                }
            }.walk((ExtensionModel)currentExtension);
            return Optional.ofNullable((ConnectionProviderModel)modelRef.get());
        }));
    }

    @Override
    public Optional<ConfigurationModel> findConfigurationModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionConfigurationModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(currentExtension -> {
            AtomicReference modelRef = new AtomicReference();
            new IdempotentExtensionWalker((ExtensionModel)currentExtension, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$currentExtension;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$currentExtension = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = DefaultExtensionModelHelper.this.getDslSyntaxResolverFor(this.val$currentExtension);
                }

                @Override
                protected void onConfiguration(ConfigurationModel model) {
                    if (this.dslSyntaxResolver.resolve(model).getElementName().equals(this.val$componentIdentifier.getName())) {
                        this.val$modelRef.set(model);
                    }
                }
            }.walk((ExtensionModel)currentExtension);
            return Optional.ofNullable((ConfigurationModel)modelRef.get());
        }));
    }

    public Optional<ParameterModel> findParameterModel(ComponentIdentifier nestedComponentId, ParameterizedModel model) {
        return this.lookupExtensionModelFor(nestedComponentId).flatMap(currentExtension -> {
            DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolverFor((ExtensionModel)currentExtension);
            return model.getAllParameterModels().stream().filter(pm -> dslSyntaxResolver.resolve((ParameterModel)pm).getElementName().equals(nestedComponentId.getName())).findAny();
        });
    }

    @Override
    public void walkToComponent(final ComponentIdentifier componentIdentifier, final Optional<ComponentAstBuilder> parent, final ExtensionModelHelper.ExtensionWalkerModelDelegate delegate, final ExtensionModel currentExtension) {
        new IdempotentExtensionWalker(){
            private final DslSyntaxResolver dslSyntaxResolver;
            private final Supplier<Boolean> sameNameModelInParent;
            {
                this.dslSyntaxResolver = DefaultExtensionModelHelper.this.getDslSyntaxResolverFor(currentExtension);
                this.sameNameModelInParent = new LazyValue<Supplier<Boolean>>(() -> parent.filter(p -> currentExtension.equals(p.getExtensionModel())).flatMap(p -> p.getModel(ComponentModel.class)).map(parentModel -> parentModel.getNestedComponents().stream().anyMatch(nested -> this.dslSyntaxResolver.resolve((NamedObject)nested).getElementName().equals(componentIdentifier.getName()))).orElse(false));
            }

            @Override
            protected void onConfiguration(ConfigurationModel model) {
                if (this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onConfiguration(model);
                    this.stop();
                }
            }

            @Override
            protected void onConnectionProvider(ConnectionProviderModel model) {
                if (this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onConnectionProvider(model);
                    this.stop();
                }
            }

            @Override
            protected void onOperation(OperationModel model) {
                if (this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onOperation(model);
                    this.stop();
                }
            }

            @Override
            protected void onSource(SourceModel model) {
                if (this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onSource(model);
                    this.stop();
                }
            }

            @Override
            protected void onConstruct(ConstructModel model) {
                DslElementSyntax dslSyntax;
                if (!this.sameNameModelInParent.get().booleanValue() && (dslSyntax = DefaultExtensionModelHelper.this.muleTopLevelDslSyntaxResolver.map(resolver -> resolver.resolve(model)).orElseGet(() -> this.dslSyntaxResolver.resolve(model))).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onConstruct(model);
                    this.stop();
                }
            }

            @Override
            protected void onNestable(ComposableModel owner, NestableElementModel model) {
                Optional<ComponentIdentifier> parentIdentifier = parent.map(ComponentAstBuilder::getIdentifier);
                if (!parentIdentifier.isPresent()) {
                    return;
                }
                if (!this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                    return;
                }
                if (!this.dslSyntaxResolver.resolve(owner).getElementName().equals(parentIdentifier.get().getName())) {
                    return;
                }
                delegate.onNestableElement(model);
                this.stop();
            }

            @Override
            protected void onType(MetadataType type) {
                DefaultExtensionModelHelper.this.resolveDslElementModel(type, currentExtension).filter(dsl -> ComponentIdentifier.builder().name(dsl.getElementName()).namespace(dsl.getPrefix()).build().equals(componentIdentifier)).ifPresent(dsl -> {
                    if (DefaultExtensionModelHelper.this.walkableType(type, dsl)) {
                        delegate.onType(type);
                    }
                    this.stop();
                });
            }
        }.walk(currentExtension);
    }

    private boolean walkableType(MetadataType type, DslElementSyntax dsl) {
        return dsl.supportsTopLevelDeclaration() || dsl.supportsChildDeclaration() && dsl.isWrapped() || ExtensionMetadataTypeUtils.getSubstitutionGroup(type).isPresent() || this.getAllSubTypes().contains(type);
    }

    @Override
    public Optional<MetadataType> findMetadataType(Class<?> type) {
        if (type != null) {
            return Optional.of(this.javaTypeLoader.load(type));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ExtensionModel> lookupExtensionModelFor(ComponentIdentifier componentIdentifier) {
        return this.lookupExtensionModelFor(componentIdentifier.getNamespace());
    }

    private Optional<ExtensionModel> lookupExtensionModelFor(String namespacePrefix) {
        return this.extensionsModels.stream().filter(e -> e.getXmlDslModel().getPrefix().equals(namespacePrefix.equals("tls") ? "mule" : namespacePrefix)).findFirst();
    }

    @Override
    public Optional<DslElementSyntax> resolveDslElementModel(MetadataType type, String namespacePrefix) {
        DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolver(namespacePrefix);
        return dslSyntaxResolver.resolve(type);
    }

    @Override
    public DslElementSyntax resolveDslElementModel(NamedObject component, ComponentIdentifier componentIdentifier) {
        DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolver(componentIdentifier);
        return dslSyntaxResolver.resolve(Objects.requireNonNull(component, "null component for identifier " + componentIdentifier.toString()));
    }

    private DslSyntaxResolver getDslSyntaxResolver(ComponentIdentifier componentIdentifier) {
        ExtensionModel extensionModel = this.lookupExtensionModelFor(componentIdentifier).orElseThrow(() -> new IllegalStateException("Extension Model in context not present for componentIdentifier: " + componentIdentifier));
        return this.getDslSyntaxResolverFor(extensionModel);
    }

    private DslSyntaxResolver getDslSyntaxResolver(String namespacePrefix) {
        Optional<ExtensionModel> optionalExtensionModel = this.lookupExtensionModelFor(namespacePrefix);
        return (DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)optionalExtensionModel.orElseThrow(() -> new IllegalStateException("Extension Model in context not present for namespace: " + namespacePrefix)));
    }

    @Override
    public Optional<DslElementSyntax> resolveDslElementModel(MetadataType metadataType, ExtensionModel extensionModel) {
        return this.getDslSyntaxResolverFor(extensionModel).resolve(metadataType);
    }

    @Override
    public DslElementSyntax resolveDslElementModel(ParameterModel parameterModel, ComponentIdentifier componentIdentifier) {
        DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolver(componentIdentifier);
        return dslSyntaxResolver.resolve(parameterModel);
    }

    @Override
    public Map<ObjectType, Optional<DslElementSyntax>> resolveSubTypes(ObjectType type) {
        LinkedHashMap singletonizedSubTypes = new LinkedHashMap();
        MetadataTypeUtils.getTypeId(type).ifPresent(typeId -> this.getTypeCatalog().getDeclaringExtension((String)typeId).flatMap(this.dslResolvingContext::getExtension).ifPresent(declaringExtension -> singletonizedSubTypes.putIfAbsent(new Pair<ExtensionModel, String>((ExtensionModel)declaringExtension, (String)typeId), type)));
        for (ObjectType subType : this.getTypeCatalog().getSubTypes(type)) {
            MetadataTypeUtils.getTypeId(subType).ifPresent(subTypeId -> this.getTypeCatalog().getDeclaringExtension((String)subTypeId).flatMap(this.dslResolvingContext::getExtension).ifPresent(declaringExtension -> singletonizedSubTypes.putIfAbsent(new Pair<ExtensionModel, String>((ExtensionModel)declaringExtension, (String)subTypeId), subType)));
        }
        return singletonizedSubTypes.entrySet().stream().filter(t -> ((ObjectType)t.getValue()).getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::isInstantiable).orElse(true)).collect(Collectors.toMap(Map.Entry::getValue, e -> ((DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)((ExtensionModel)((Pair)e.getKey()).getFirst()))).resolve((MetadataType)e.getValue()), (x, y) -> x, LinkedHashMap::new));
    }

    private Collection<ObjectType> getAllSubTypes() {
        return this.getTypeCatalog().getAllSubTypes();
    }

    @Override
    public TypeCatalog getTypeCatalog() {
        return this.dslResolvingContext.getTypeCatalog();
    }

    @Override
    public DslSyntaxResolver getDslSyntaxResolverFor(ExtensionModel extensionModel) {
        return (DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)extensionModel);
    }

    static class NestedComponentVisitor
    implements ComponentModelVisitor {
        private final Reference<TypedComponentIdentifier.ComponentType> reference;

        public NestedComponentVisitor(Reference<TypedComponentIdentifier.ComponentType> reference) {
            this.reference = reference;
        }

        @Override
        public void visit(NestedChainModel component) {
            this.reference.set(TypedComponentIdentifier.ComponentType.SCOPE);
        }

        @Override
        public void visit(NestedRouteModel component) {
            this.reference.set(TypedComponentIdentifier.ComponentType.ROUTER);
        }

        @Override
        public void visit(NestedComponentModel component) {
        }

        @Override
        public void visit(OperationModel model) {
        }

        @Override
        public void visit(SourceModel model) {
        }

        @Override
        public void visit(ConstructModel model) {
        }
    }
}

