/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.util.Preconditions;

public final class MetadataAttributes {
    private final MetadataKey key;
    private final String category;
    private final Map<String, String> parameters;
    private final String outputResolver;
    private final String attributesResolver;

    private MetadataAttributes(MetadataKey key, String category, Map<String, String> parameters, String outputResolver, String attributesResolver) {
        this.key = key;
        this.category = category;
        this.parameters = parameters;
        this.outputResolver = outputResolver;
        this.attributesResolver = attributesResolver;
    }

    public static MetadataAttributesBuilder builder() {
        return new MetadataAttributesBuilder();
    }

    public Optional<MetadataKey> getKey() {
        return Optional.ofNullable(this.key);
    }

    public String getParameterResolverName(String parameterName) {
        Preconditions.checkArgument(this.parameters.containsKey(parameterName), "Parameter named %s is not associated to a resolver");
        return this.parameters.get(parameterName);
    }

    public String getCategoryName() {
        return this.category;
    }

    public Optional<String> getOutputResolverName() {
        return Optional.ofNullable(this.outputResolver);
    }

    public Optional<String> getOutputAttributesResolverName() {
        return Optional.ofNullable(this.attributesResolver);
    }

    public static class MetadataAttributesBuilder {
        private MetadataKey metadataKey;
        private String categoryName;
        private Map<String, String> parameterResolvers = new HashMap<String, String>();
        private String outputResolver;
        private String outputAttributesResolver;

        private MetadataAttributesBuilder() {
        }

        public MetadataAttributesBuilder withParameterResolver(String parameterName, String resolverName) {
            this.parameterResolvers.put(parameterName, resolverName);
            return this;
        }

        public MetadataAttributesBuilder withOutputResolver(String outputResolver) {
            this.outputResolver = outputResolver;
            return this;
        }

        public MetadataAttributesBuilder withOutputAttributesResolver(String outputAttributesResolver) {
            this.outputAttributesResolver = outputAttributesResolver;
            return this;
        }

        public MetadataAttributesBuilder withKey(MetadataKey key) {
            this.metadataKey = key;
            return this;
        }

        public MetadataAttributesBuilder withCategoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public MetadataAttributes build() {
            return new MetadataAttributes(this.metadataKey, this.categoryName, this.parameterResolvers, this.outputResolver, this.outputAttributesResolver);
        }
    }
}

