/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.exception;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Pair;

public class PropertyNotFoundException
extends MuleRuntimeException {
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final long serialVersionUID = -3570854244058568638L;
    private final List<Pair<String, String>> unresolvedKeys;

    public PropertyNotFoundException(Pair<String, String> resolverKeyPair) {
        super(PropertyNotFoundException.createFailureException(resolverKeyPair));
        this.unresolvedKeys = Collections.singletonList(resolverKeyPair);
    }

    private static I18nMessage createFailureException(Pair<String, String> resolverKeyPair) {
        return I18nMessageFactory.createStaticMessage(PropertyNotFoundException.createMessageForLeakKey(resolverKeyPair));
    }

    private static String createMessageForLeakKey(Pair<String, String> resolverKeyPair) {
        return String.format("Couldn't find configuration property value for key %s", PLACEHOLDER_PREFIX + resolverKeyPair.getSecond() + PLACEHOLDER_SUFFIX);
    }

    public PropertyNotFoundException(PropertyNotFoundException propertyNotFoundException, Pair<String, String> resolverKeyPair) {
        super(PropertyNotFoundException.createFailureException(resolverKeyPair));
        ArrayList<Pair<String, String>> keys = new ArrayList<Pair<String, String>>(propertyNotFoundException.getUnresolvedKeys());
        keys.add(resolverKeyPair);
        this.unresolvedKeys = Collections.unmodifiableList(keys);
    }

    public List<Pair<String, String>> getUnresolvedKeys() {
        return this.unresolvedKeys;
    }
}

