/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.config.internal.factories.ConstantFactoryBean;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.InternalCustomizationService;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

abstract class AbstractSpringMuleContextServiceConfigurator {
    private static final Set<String> NO_DOMAIN_SERVICES = Set.of("_muleSecurityManager", "_muleMessageProcessingManager", "_muleStreamCloserService", "_muleProcessingTimeWatcher", "_mulePolicyManager", "_muleExceptionLocationProvider", "_muleMessageProcessingFlowTraceManager");
    private final InternalCustomizationService customizationService;
    private final BeanDefinitionRegistry beanDefinitionRegistry;

    protected AbstractSpringMuleContextServiceConfigurator(InternalCustomizationService customizationService, BeanDefinitionRegistry beanDefinitionRegistry) {
        this.customizationService = customizationService;
        this.beanDefinitionRegistry = beanDefinitionRegistry;
    }

    protected void registerContextServices(Map<String, BeanDefinition> contextServices, boolean domainArtifact) {
        contextServices.entrySet().stream().filter(service -> !domainArtifact || !NO_DOMAIN_SERVICES.contains(service.getKey())).forEach(service -> this.registerBeanDefinition((String)service.getKey(), (BeanDefinition)service.getValue()));
    }

    protected static BeanDefinition getBeanDefinition(Class<?> beanType) {
        return AbstractSpringMuleContextServiceConfigurator.getBeanDefinition(beanType, false);
    }

    protected static BeanDefinition getBeanDefinition(Class<?> beanType, boolean primary) {
        BeanDefinitionBuilder beanDefinitionBuilder = AbstractSpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(beanType);
        if (primary) {
            beanDefinitionBuilder.setPrimary(true);
        }
        return beanDefinitionBuilder.getBeanDefinition();
    }

    protected void registerConstantBeanDefinition(String serviceId, Object impl) {
        this.registerConstantBeanDefinition(serviceId, impl, false);
    }

    protected void registerConstantBeanDefinition(String serviceId, Object impl, boolean inject) {
        this.registerBeanDefinition(serviceId, AbstractSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(impl, inject));
    }

    protected void registerBeanDefinition(String serviceId, BeanDefinition beanDefinition) {
        beanDefinition = this.customizationService.getOverriddenService(serviceId).map(customService -> this.getCustomServiceBeanDefinition((CustomService)customService, serviceId)).orElse(beanDefinition);
        this.beanDefinitionRegistry.registerBeanDefinition(serviceId, beanDefinition);
    }

    protected void loadServiceConfigurators() {
        ServiceConfigurator.lookupServiceConfigurators(this.getClass().getClassLoader()).forEach(customizationInfo -> customizationInfo.configure(this.getCustomizationService()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isServiceRuntimeProvided(CustomService<?> customService) {
        if (customService.getServiceImpl().map(Service.class::isInstance).orElse(false) != false) return true;
        if (customService.getServiceClass().map(Service.class::isAssignableFrom).orElse(false) == false) return false;
        return true;
    }

    protected BeanDefinition getCustomServiceBeanDefinition(CustomService customService, String serviceId) {
        AbstractBeanDefinition beanDefinition;
        Optional customServiceClass = customService.getServiceClass();
        Optional customServiceImpl = customService.getServiceImpl();
        if (customServiceClass.isPresent()) {
            beanDefinition = AbstractSpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(customServiceClass.get()).getBeanDefinition();
        } else if (customServiceImpl.isPresent()) {
            Object servImpl = customServiceImpl.get();
            beanDefinition = servImpl instanceof Service ? this.addServiceProxyParamsInjector(servImpl) : AbstractSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(servImpl, true);
        } else {
            throw new IllegalStateException("A custom service must define a service class or instance");
        }
        if ("_muleObjectStoreManager".equals(serviceId)) {
            beanDefinition.setPrimary(true);
        }
        return beanDefinition;
    }

    protected BeanDefinition addServiceProxyParamsInjector(Object servImpl) {
        return AbstractSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(servImpl, true);
    }

    protected static BeanDefinition getConstantObjectBeanDefinition(Object impl) {
        return AbstractSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(impl, false);
    }

    protected static BeanDefinition getConstantObjectBeanDefinition(Object impl, boolean inject) {
        return AbstractSpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgValue(impl).addConstructorArgValue((Object)inject).getBeanDefinition();
    }

    protected static BeanDefinitionBuilder getBeanDefinitionBuilder(Class<?> beanType) {
        return BeanDefinitionBuilder.genericBeanDefinition(beanType);
    }

    protected boolean containsBeanDefinition(String beanName) {
        return this.beanDefinitionRegistry.containsBeanDefinition(beanName);
    }

    protected InternalCustomizationService getCustomizationService() {
        return this.customizationService;
    }

    protected BeanDefinitionRegistry getBeanDefinitionRegistry() {
        return this.beanDefinitionRegistry;
    }
}

