/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.registry.TransformerResolver;
import org.mule.runtime.core.internal.transformer.ResolverException;
import org.mule.runtime.core.internal.transformer.graph.CompositeConverterFilter;
import org.mule.runtime.core.internal.transformer.graph.NameConverterFilter;
import org.mule.runtime.core.internal.transformer.graph.PriorityWeightingConverterFilter;
import org.mule.runtime.core.internal.transformer.graph.SynchronizedTransformationGraph;
import org.mule.runtime.core.internal.transformer.graph.TransformationGraphLookupStrategy;
import org.mule.runtime.core.internal.transformer.graph.TransformationLengthConverterFilter;
import org.mule.runtime.core.internal.transformer.graph.TypeMatchingVertexesFilter;

public class GraphTransformerResolver
implements TransformerResolver {
    private static final int DEFAULT_CACHE_SIZE = 100;
    private static final float LOAD_FACTOR = 0.75f;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final SynchronizedTransformationGraph graph = new SynchronizedTransformationGraph();
    private final CompositeConverterFilter converterFilter;
    private final Map<String, Converter> cache;
    private final TransformationGraphLookupStrategy lookupStrategyTransformation = new TransformationGraphLookupStrategy(this.graph);

    public GraphTransformerResolver() {
        this.converterFilter = new CompositeConverterFilter(new TypeMatchingVertexesFilter(), new TransformationLengthConverterFilter(), new PriorityWeightingConverterFilter(), new NameConverterFilter());
        this.cache = new LinkedHashMap<String, Converter>(100, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Converter> eldest) {
                return this.size() > 100;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transformer resolve(DataType source, DataType result) throws ResolverException {
        String cacheKey = this.getDataTypeSourceResultPairHash(source, result);
        this.readWriteLock.readLock().lock();
        try {
            if (this.cache.containsKey(cacheKey)) {
                Transformer transformer = this.cache.get(cacheKey);
                return transformer;
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        List<Converter> converters = this.converterFilter.filter(this.lookupStrategyTransformation.lookupConverters(source, result), source, result);
        if (converters.size() > 1) {
            throw new ResolverException(CoreMessages.transformHasMultipleMatches(source.getType(), result.getType(), converters));
        }
        Converter converter = converters.isEmpty() ? null : converters.get(0);
        this.readWriteLock.writeLock().lock();
        try {
            this.cache.put(cacheKey, converter);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return converter;
    }

    private String getDataTypeSourceResultPairHash(DataType source, DataType result) {
        StringBuilder builder = new StringBuilder();
        builder.append(source.getClass().getName());
        builder.append(source.hashCode());
        builder.append(":");
        builder.append(result.getClass().getName());
        builder.append(result.hashCode());
        return builder.toString();
    }

    @Override
    public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
        this.readWriteLock.writeLock().lock();
        try {
            if (!(transformer instanceof Converter)) {
                return;
            }
            this.cache.clear();
            if (registryAction == TransformerResolver.RegistryAction.ADDED) {
                this.graph.addConverter((Converter)transformer);
            } else if (registryAction == TransformerResolver.RegistryAction.REMOVED) {
                this.graph.removeConverter((Converter)transformer);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

