/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.connection;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.model.parameter.AbstractStereotypedModel;

public class ImmutableConnectionProviderModel
extends AbstractStereotypedModel
implements ConnectionProviderModel {
    private final ConnectionManagementType connectionManagementType;
    private final Set<ExternalLibraryModel> externalLibraryModels;
    private final boolean supportsConnectivityTesting;
    private final boolean supportsXa;
    private Set<String> semanticTerms;

    public ImmutableConnectionProviderModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, ConnectionManagementType connectionManagementType, boolean supportsConnectivityTesting, Set<ExternalLibraryModel> externalLibraryModels, DisplayModel displayModel, StereotypeModel stereotype, Set<ModelProperty> modelProperties) {
        this(name, description, parameterGroupModels, connectionManagementType, supportsConnectivityTesting, externalLibraryModels, displayModel, stereotype, modelProperties, null);
    }

    public ImmutableConnectionProviderModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, ConnectionManagementType connectionManagementType, boolean supportsConnectivityTesting, Set<ExternalLibraryModel> externalLibraryModels, DisplayModel displayModel, StereotypeModel stereotype, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel) {
        this(name, description, parameterGroupModels, connectionManagementType, supportsConnectivityTesting, externalLibraryModels, displayModel, stereotype, modelProperties, deprecationModel, null);
    }

    public ImmutableConnectionProviderModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, ConnectionManagementType connectionManagementType, boolean supportsConnectivityTesting, Set<ExternalLibraryModel> externalLibraryModels, DisplayModel displayModel, StereotypeModel stereotype, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel, Set<String> semanticTerms) {
        this(name, description, parameterGroupModels, connectionManagementType, supportsConnectivityTesting, false, externalLibraryModels, displayModel, stereotype, modelProperties, deprecationModel, semanticTerms, null);
    }

    public ImmutableConnectionProviderModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, ConnectionManagementType connectionManagementType, boolean supportsConnectivityTesting, Set<ExternalLibraryModel> externalLibraryModels, DisplayModel displayModel, StereotypeModel stereotype, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel, Set<String> semanticTerms, MuleVersion minMuleVersion) {
        this(name, description, parameterGroupModels, connectionManagementType, supportsConnectivityTesting, false, externalLibraryModels, displayModel, stereotype, modelProperties, deprecationModel, semanticTerms, minMuleVersion);
    }

    public ImmutableConnectionProviderModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, ConnectionManagementType connectionManagementType, boolean supportsConnectivityTesting, boolean supportsXa, Set<ExternalLibraryModel> externalLibraryModels, DisplayModel displayModel, StereotypeModel stereotype, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel, Set<String> semanticTerms, MuleVersion minMuleVersion) {
        super(name, description, parameterGroupModels, displayModel, stereotype, modelProperties, deprecationModel, minMuleVersion);
        ImmutableConnectionProviderModel.checkArgument(connectionManagementType != null, "connectionManagementType cannot be null");
        this.connectionManagementType = connectionManagementType;
        this.externalLibraryModels = Collections.unmodifiableSet(externalLibraryModels);
        this.supportsConnectivityTesting = supportsConnectivityTesting;
        this.supportsXa = supportsXa;
        this.semanticTerms = semanticTerms != null ? Collections.unmodifiableSet(semanticTerms) : Collections.emptySet();
    }

    @Override
    public ConnectionManagementType getConnectionManagementType() {
        return this.connectionManagementType;
    }

    @Override
    public Set<ExternalLibraryModel> getExternalLibraryModels() {
        return this.externalLibraryModels;
    }

    @Override
    public boolean supportsConnectivityTesting() {
        return this.supportsConnectivityTesting;
    }

    @Override
    public boolean supportsXa() {
        return this.supportsXa;
    }

    @Override
    public Set<String> getSemanticTerms() {
        if (this.semanticTerms == null) {
            this.semanticTerms = Collections.emptySet();
        }
        return this.semanticTerms;
    }

    @Override
    public String toString() {
        return "ImmutableConnectionProviderModel{connectionManagementType=" + (Object)((Object)this.connectionManagementType) + ", externalLibraryModels=" + this.externalLibraryModels + ", supportsConnectivityTesting=" + this.supportsConnectivityTesting + ", semanticTerms=" + this.semanticTerms + "} " + super.toString();
    }
}

