/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.AdditionalPluginDependencies;
import org.mule.maven.pom.parser.api.model.ArtifactCoordinates;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.internal.util.JarInfo;
import org.mule.runtime.module.deployment.impl.internal.maven.ArtifactClassLoaderConfigurationBuilder;

public class LightweightClassLoaderConfigurationBuilder
extends ArtifactClassLoaderConfigurationBuilder {
    private final MavenClient mavenClient;
    private final List<BundleDependency> nonProvidedDependencies;
    private final Map<Pair<String, String>, Boolean> sharedLibraryAlreadyExported = new HashMap<Pair<String, String>, Boolean>();

    public LightweightClassLoaderConfigurationBuilder(File artifactFolder, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor artifactBundleDescriptor, MavenClient mavenClient, List<BundleDependency> nonProvidedDependencies) {
        super(artifactFolder, artifactBundleDescriptor);
        this.mavenClient = mavenClient;
        this.nonProvidedDependencies = nonProvidedDependencies;
    }

    @Override
    protected List<URI> processPluginAdditionalDependenciesURIs(BundleDependency bundleDependency) {
        List<org.mule.maven.pom.parser.api.model.BundleDependency> resolvedAdditionalDependencies = this.mavenClient.resolveArtifactDependencies(bundleDependency.getAdditionalDependenciesList().stream().map(additionalDependency -> LightweightClassLoaderConfigurationBuilder.toMavenClientBundleDescriptor(additionalDependency.getDescriptor())).collect(Collectors.toList()), Optional.of(this.mavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation()), Optional.empty());
        return resolvedAdditionalDependencies.stream().map(org.mule.maven.pom.parser.api.model.BundleDependency::getBundleUri).collect(Collectors.toList());
    }

    private static BundleDescriptor toMavenClientBundleDescriptor(org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor descriptor) {
        return new BundleDescriptor.Builder().setGroupId(descriptor.getGroupId()).setArtifactId(descriptor.getArtifactId()).setVersion(descriptor.getVersion()).setType(descriptor.getType()).setClassifier(descriptor.getClassifier().orElse(null)).build();
    }

    @Override
    protected void findAndExportSharedLibrary(String groupId, String artifactId) {
        Pair sharedLibraryKey = Pair.of((Object)groupId, (Object)artifactId);
        if (this.sharedLibraryAlreadyExported.containsKey(sharedLibraryKey)) {
            return;
        }
        this.sharedLibraryAlreadyExported.put((Pair<String, String>)sharedLibraryKey, true);
        Optional<BundleDependency> matchingLibrary = this.nonProvidedDependencies.stream().filter(bundleDependency -> bundleDependency.getDescriptor().getGroupId().equals(groupId) && bundleDependency.getDescriptor().getArtifactId().equals(artifactId)).findAny();
        BundleDependency bundleDependency2 = matchingLibrary.orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Dependency %s:%s could not be found within the artifact %s. It must be declared within the maven dependencies of the artifact.", groupId, artifactId, this.artifactFolder.getName()))));
        this.exportBundleDependencyAndTransitiveDependencies(bundleDependency2);
    }

    private void exportBundleDependencyAndTransitiveDependencies(BundleDependency bundleDependency) {
        BundleDependency resolvedBundleDependency = bundleDependency;
        if (bundleDependency.getBundleUri() == null) {
            resolvedBundleDependency = this.nonProvidedDependencies.stream().filter(nonProvidedDependency -> nonProvidedDependency.getDescriptor().getGroupId().equals(bundleDependency.getDescriptor().getGroupId()) && nonProvidedDependency.getDescriptor().getArtifactId().equals(bundleDependency.getDescriptor().getArtifactId())).findAny().orElse(bundleDependency);
        }
        JarInfo jarInfo = this.fileJarExplorer.explore(resolvedBundleDependency.getBundleUri());
        this.exportingPackages(jarInfo.getPackages());
        this.exportingResources(jarInfo.getResources());
        jarInfo.getServices().forEach(service -> this.exportingResources(Collections.singleton("META-INF/services/" + service.getServiceInterface())));
        resolvedBundleDependency.getTransitiveDependenciesList().forEach(this::exportBundleDependencyAndTransitiveDependencies);
    }

    @Override
    protected Map<ArtifactCoordinates, AdditionalPluginDependencies> doProcessAdditionalPluginLibraries(MavenPomParser parser) {
        Map<ArtifactCoordinates, AdditionalPluginDependencies> deployableArtifactAdditionalLibrariesMap = super.doProcessAdditionalPluginLibraries(parser);
        HashMap<ArtifactCoordinates, AdditionalPluginDependencies> effectivePluginsAdditionalLibrariesMap = new HashMap<ArtifactCoordinates, AdditionalPluginDependencies>(deployableArtifactAdditionalLibrariesMap);
        this.nonProvidedDependencies.stream().filter(bundleDependency -> ArtifactType.PLUGIN.getMavenArtifactClassifier().equals(bundleDependency.getDescriptor().getClassifier().orElse(null))).forEach(bundleDependency -> {
            MavenPomModel effectiveModel;
            try {
                effectiveModel = this.mavenClient.getEffectiveModel(FileUtils.toFile((URL)bundleDependency.getBundleUri().toURL()), Optional.empty());
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException(e);
            }
            if (effectiveModel.getPomFile().isPresent()) {
                MavenPomParser parserForPlugin = MavenPomParserProvider.discoverProvider().createMavenPomParserClient(effectiveModel.getPomFile().get().toPath(), this.getActiveProfiles());
                Map<ArtifactCoordinates, AdditionalPluginDependencies> pomAdditionalPluginDependenciesForArtifact = parserForPlugin.getPomAdditionalPluginDependenciesForArtifacts();
                pomAdditionalPluginDependenciesForArtifact.forEach((artifact, additionalDependenciesForArtifact) -> {
                    if (deployableArtifactAdditionalLibrariesMap.containsKey(artifact)) {
                        AdditionalPluginDependencies additionalPluginDependenciesForPlugin = (AdditionalPluginDependencies)deployableArtifactAdditionalLibrariesMap.get(artifact);
                        List effectiveAdditionalDependencies = additionalDependenciesForArtifact.getAdditionalDependencies().stream().filter(additionalLibrary -> {
                            boolean additionalLibraryDefinedAtDeployableArtifact = this.existsInLibrariesMap(deployableArtifactAdditionalLibrariesMap, (ArtifactCoordinates)artifact, (BundleDescriptor)additionalLibrary);
                            if (!additionalLibraryDefinedAtDeployableArtifact) {
                                Optional<BundleDescriptor> additionalLibraryDefinedByAnotherPlugin = this.findLibraryInAdditionalLibrariesMap(effectivePluginsAdditionalLibrariesMap, (ArtifactCoordinates)artifact, (BundleDescriptor)additionalLibrary);
                                try {
                                    return !additionalLibraryDefinedByAnotherPlugin.isPresent() || new MuleVersion(additionalLibrary.getVersion()).newerThan(additionalLibraryDefinedByAnotherPlugin.get().getVersion());
                                }
                                catch (IllegalStateException e) {
                                    return additionalLibrary.getVersion().compareTo(additionalLibraryDefinedByAnotherPlugin.get().getVersion()) > 0;
                                }
                            }
                            return false;
                        }).collect(Collectors.toCollection(LinkedList::new));
                        AdditionalPluginDependencies effectiveAdditionalPluginDependenciesForPlugin = new AdditionalPluginDependencies(additionalPluginDependenciesForPlugin, effectiveAdditionalDependencies);
                        deployableArtifactAdditionalLibrariesMap.replace((ArtifactCoordinates)artifact, effectiveAdditionalPluginDependenciesForPlugin);
                    } else {
                        effectivePluginsAdditionalLibrariesMap.put((ArtifactCoordinates)artifact, (AdditionalPluginDependencies)additionalDependenciesForArtifact);
                    }
                });
            }
        });
        return effectivePluginsAdditionalLibrariesMap;
    }

    private boolean existsInLibrariesMap(Map<ArtifactCoordinates, AdditionalPluginDependencies> additionalLibrariesPerPluginMap, ArtifactCoordinates plugin, BundleDescriptor additionalLibrary) {
        List<BundleDescriptor> additionalLibraries = additionalLibrariesPerPluginMap.get(plugin).getAdditionalDependencies();
        if (additionalLibraries == null) {
            return false;
        }
        return additionalLibraries.contains(additionalLibrary);
    }

    private Optional<BundleDescriptor> findLibraryInAdditionalLibrariesMap(Map<ArtifactCoordinates, AdditionalPluginDependencies> additionalLibrariesPerPluginMap, ArtifactCoordinates plugin, BundleDescriptor additionalLibrary) {
        List<BundleDescriptor> additionalLibraries = additionalLibrariesPerPluginMap.get(plugin).getAdditionalDependencies();
        if (additionalLibraries == null) {
            return Optional.empty();
        }
        return additionalLibraries.stream().filter(bundleDescriptor -> bundleDescriptor.equals(additionalLibrary)).findAny();
    }
}

