/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.ResourcesGenerator;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.resources.ProcessingEnvironmentAware;

public final class AnnotationProcessorResourceGenerator
implements ResourcesGenerator {
    private final ProcessingEnvironment processingEnv;
    private final List<GeneratedResourceFactory> resourceFactories;

    public AnnotationProcessorResourceGenerator(List<GeneratedResourceFactory> resourceFactories, ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.resourceFactories = Collections.unmodifiableList(new ArrayList<GeneratedResourceFactory>(AnnotationProcessorResourceGenerator.enrichFactories(resourceFactories, processingEnv)));
    }

    protected void write(GeneratedResource resource) {
        FileObject file;
        try {
            file = this.processingEnv.getFiler().createResource(resource.isAvailableInArtifact() ? StandardLocation.CLASS_OUTPUT : StandardLocation.SOURCE_OUTPUT, "", resource.getPath(), new Element[0]);
        }
        catch (IOException e) {
            throw this.wrapException(e, resource);
        }
        try (OutputStream out = file.openOutputStream();){
            out.write(resource.getContent());
            out.flush();
        }
        catch (IOException e) {
            throw this.wrapException(e, resource);
        }
    }

    private RuntimeException wrapException(Exception e, GeneratedResource resource) {
        return new RuntimeException(String.format("Could not write generated resource '%s'", resource.getPath()), e);
    }

    private static Collection<GeneratedResourceFactory> enrichFactories(List<GeneratedResourceFactory> resourceFactories, ProcessingEnvironment processingEnv) {
        resourceFactories.forEach(factory -> {
            if (factory instanceof ProcessingEnvironmentAware) {
                ProcessingEnvironmentAware peaFacotry = (ProcessingEnvironmentAware)((Object)factory);
                peaFacotry.setProcessingEnvironment(processingEnv);
            }
        });
        return resourceFactories;
    }

    @Override
    public List<GeneratedResource> generateFor(ExtensionModel extensionModel) {
        List<GeneratedResource> resources = this.resourceFactories.stream().map(factory -> factory.generateResource(extensionModel)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toImmutableList());
        resources.forEach(this::write);
        return resources;
    }
}

