/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs.identity;

import org.mule.apache.xerces.impl.xpath.XPath;
import org.mule.apache.xerces.impl.xpath.XPathException;
import org.mule.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.mule.apache.xerces.impl.xs.identity.ValueStore;
import org.mule.apache.xerces.impl.xs.identity.XPathMatcher;
import org.mule.apache.xerces.impl.xs.util.ShortListImpl;
import org.mule.apache.xerces.util.SymbolTable;
import org.mule.apache.xerces.util.XMLChar;
import org.mule.apache.xerces.xni.NamespaceContext;
import org.mule.apache.xerces.xs.ShortList;
import org.mule.apache.xerces.xs.XSComplexTypeDefinition;
import org.mule.apache.xerces.xs.XSTypeDefinition;

public class Field {
    protected final XPath fXPath;
    protected final IdentityConstraint fIdentityConstraint;
    protected String fXpathDefaultNamespace;

    public Field(XPath xpath, IdentityConstraint identityConstraint, String xpathDefaultNamespace) {
        this.fXPath = xpath;
        this.fIdentityConstraint = identityConstraint;
        this.fXpathDefaultNamespace = xpathDefaultNamespace;
    }

    public org.mule.apache.xerces.impl.xpath.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public XPathMatcher createMatcher(ValueStore store) {
        return new Matcher(this.fXPath, store);
    }

    public String toString() {
        return this.fXPath.toString();
    }

    public String getXPathDefaultNamespace() {
        return this.fXpathDefaultNamespace;
    }

    protected class Matcher
    extends XPathMatcher {
        protected final ValueStore fStore;
        protected boolean fMayMatch;

        public Matcher(XPath xpath, ValueStore store) {
            super(xpath);
            this.fMayMatch = true;
            this.fStore = store;
        }

        @Override
        protected void matched(Object actualValue, short valueType, ShortList itemValueType, boolean isNil) {
            super.matched(actualValue, valueType, itemValueType, isNil);
            if (isNil && Field.this.fIdentityConstraint.getCategory() == 1) {
                String code = "KeyMatchesNillable";
                this.fStore.reportError(code, new Object[]{this.fStore.getElementName(), Field.this.fIdentityConstraint.getIdentityConstraintName()});
            }
            this.fStore.addValue(Field.this, this.fMayMatch, actualValue, this.convertToPrimitiveKind(valueType), this.convertToPrimitiveKind(itemValueType));
            this.fMayMatch = false;
        }

        private short convertToPrimitiveKind(short valueType) {
            if (valueType <= 20) {
                return valueType;
            }
            if (valueType <= 29) {
                return 2;
            }
            if (valueType <= 42) {
                return 4;
            }
            return valueType;
        }

        private ShortList convertToPrimitiveKind(ShortList itemValueType) {
            if (itemValueType != null) {
                short type;
                int i;
                int length = itemValueType.getLength();
                for (i = 0; i < length && (type = itemValueType.item(i)) == this.convertToPrimitiveKind(type); ++i) {
                }
                if (i != length) {
                    short[] arr = new short[length];
                    for (int j = 0; j < i; ++j) {
                        arr[j] = itemValueType.item(j);
                    }
                    while (i < length) {
                        arr[i] = this.convertToPrimitiveKind(itemValueType.item(i));
                        ++i;
                    }
                    return new ShortListImpl(arr, arr.length);
                }
            }
            return itemValueType;
        }

        @Override
        protected void handleContent(XSTypeDefinition type, boolean nillable, Object actualValue, short valueType, ShortList itemValueType) {
            if (type == null || type.getTypeCategory() == 15 && ((XSComplexTypeDefinition)type).getContentType() != 1) {
                this.fStore.reportError("cvc-id.3", new Object[]{Field.this.fIdentityConstraint.getName(), this.fStore.getElementName()});
            }
            this.fMatchedString = actualValue;
            this.matched(this.fMatchedString, valueType, itemValueType, nillable);
        }
    }

    public static class XPath
    extends org.mule.apache.xerces.impl.xpath.XPath {
        public XPath(String xpath, SymbolTable symbolTable, NamespaceContext context) throws XPathException {
            super(XPath.fixupXPath(xpath), symbolTable, context);
            for (int i = 0; i < this.fLocationPaths.length; ++i) {
                for (int j = 0; j < this.fLocationPaths[i].steps.length; ++j) {
                    XPath.Axis axis = this.fLocationPaths[i].steps[j].axis;
                    if (axis.type != 2 || j >= this.fLocationPaths[i].steps.length - 1) continue;
                    throw new XPathException("c-fields-xpaths");
                }
            }
        }

        private static String fixupXPath(String xpath) {
            int end = xpath.length();
            boolean whitespace = true;
            for (int offset = 0; offset < end; ++offset) {
                char c = xpath.charAt(offset);
                if (whitespace) {
                    if (XMLChar.isSpace(c)) continue;
                    if (c == '.' || c == '/') {
                        whitespace = false;
                        continue;
                    }
                    if (c == '|') continue;
                    return XPath.fixupXPath2(xpath, offset, end);
                }
                if (c != '|') continue;
                whitespace = true;
            }
            return xpath;
        }

        private static String fixupXPath2(String xpath, int offset, int end) {
            StringBuffer buffer = new StringBuffer(end + 2);
            for (int i = 0; i < offset; ++i) {
                buffer.append(xpath.charAt(i));
            }
            buffer.append("./");
            boolean whitespace = false;
            while (offset < end) {
                char c = xpath.charAt(offset);
                if (whitespace) {
                    if (!XMLChar.isSpace(c)) {
                        if (c == '.' || c == '/') {
                            whitespace = false;
                        } else if (c != '|') {
                            buffer.append("./");
                            whitespace = false;
                        }
                    }
                } else if (c == '|') {
                    whitespace = true;
                }
                buffer.append(c);
                ++offset;
            }
            return buffer.toString();
        }
    }
}

