/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.extension.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.internal.dsl.model.extension.xml.ComponentModelReaderHelper;
import org.mule.runtime.config.internal.dsl.model.extension.xml.MacroExpansionModuleModel;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.extension.api.property.XmlExtensionModelProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroExpansionModulesModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroExpansionModulesModel.class);
    private static final String FILE_MACRO_EXPANSION_DELIMITER = StringUtils.repeat((char)'*', (int)80) + System.lineSeparator();
    private static final String FILE_MACRO_EXPANSION_SECTION_DELIMITER = StringUtils.repeat((char)'-', (int)80) + System.lineSeparator();
    private final ApplicationModel applicationModel;
    private final List<ExtensionModel> sortedExtensions;

    public MacroExpansionModulesModel(ApplicationModel applicationModel, Set<ExtensionModel> extensions) {
        this.applicationModel = applicationModel;
        this.sortedExtensions = this.calculateExtensionByTopologicalOrder(extensions);
    }

    public void expand() {
        boolean hasMacroExpansionExtension;
        for (ExtensionModel sortedExtension : this.sortedExtensions) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("macro expanding '%s' connector, xmlns:%s=\"%s\"", sortedExtension.getName(), sortedExtension.getXmlDslModel().getPrefix(), sortedExtension.getXmlDslModel().getNamespace()));
            }
            new MacroExpansionModuleModel(this.applicationModel, sortedExtension).expand();
        }
        if (LOGGER.isDebugEnabled() && (hasMacroExpansionExtension = this.sortedExtensions.stream().anyMatch(extensionModel -> extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent()))) {
            this.applicationModel.executeOnlyOnMuleRoot(rootComponentModel -> {
                StringBuilder buf = new StringBuilder(1024);
                buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_DELIMITER);
                buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_SECTION_DELIMITER);
                buf.append("Filename: ").append(rootComponentModel.getConfigFileName().orElse("<unnamed>"));
                buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_SECTION_DELIMITER);
                buf.append(ComponentModelReaderHelper.toXml(rootComponentModel));
                buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_DELIMITER);
                LOGGER.debug(buf.toString());
            });
        }
    }

    private List<ExtensionModel> calculateExtensionByTopologicalOrder(Set<ExtensionModel> extensions) {
        ArrayList<ExtensionModel> result = new ArrayList<ExtensionModel>();
        Map allExtensionsByNamespace = extensions.stream().filter(extensionModel -> extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent()).collect(Collectors.toMap(extModel -> extModel.getXmlDslModel().getNamespace(), Function.identity()));
        if (!allExtensionsByNamespace.isEmpty()) {
            HashSet extensionsUsedInApp = new HashSet();
            this.applicationModel.executeOnEveryMuleComponentTree(rootComponentModel -> extensionsUsedInApp.addAll(this.getDirectExpandableNamespaceDependencies((ComponentModel)rootComponentModel, allExtensionsByNamespace.keySet())));
            if (!extensionsUsedInApp.isEmpty()) {
                DirectedMultigraph namespaceDAG = new DirectedMultigraph(DefaultEdge.class);
                extensionsUsedInApp.forEach(arg_0 -> this.lambda$calculateExtensionByTopologicalOrder$5((DirectedGraph)namespaceDAG, allExtensionsByNamespace, arg_0));
                TopologicalOrderIterator graphIterator = new TopologicalOrderIterator((DirectedGraph)namespaceDAG);
                while (graphIterator.hasNext()) {
                    String namespace = (String)graphIterator.next();
                    if (!allExtensionsByNamespace.containsKey(namespace)) continue;
                    result.add((ExtensionModel)allExtensionsByNamespace.get(namespace));
                }
            }
        }
        return result;
    }

    private void fillDependencyGraph(DirectedGraph<String, DefaultEdge> g, String sourceVertex, Map<String, ExtensionModel> allExtensionsByNamespace) {
        ExtensionModel extensionModel = allExtensionsByNamespace.get(sourceVertex);
        g.addVertex((Object)sourceVertex);
        for (String dependencyNamespace : this.getDependenciesOrFail(extensionModel)) {
            if (!allExtensionsByNamespace.containsKey(dependencyNamespace)) continue;
            g.addVertex((Object)dependencyNamespace);
            g.addEdge((Object)sourceVertex, (Object)dependencyNamespace);
            this.fillDependencyGraph(g, dependencyNamespace, allExtensionsByNamespace);
        }
    }

    private Set<String> getDependenciesOrFail(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(XmlExtensionModelProperty.class).orElseThrow(() -> new IllegalArgumentException(String.format("The current extension [%s] (namespace [%s]) does not have the macro expansion model property, it should have never reach here.", extensionModel.getName(), extensionModel.getXmlDslModel().getNamespace()))).getNamespacesDependencies();
    }

    private Set<String> getDirectExpandableNamespaceDependencies(ComponentModel rootComponentModel, Set<String> namespacesExtensions) {
        return MacroExpansionModulesModel.getUsedNamespaces(rootComponentModel).stream().filter(namespacesExtensions::contains).collect(Collectors.toSet());
    }

    public static Set<String> getUsedNamespaces(ComponentModel rootComponentModel) {
        return rootComponentModel.getParameters().entrySet().stream().filter(parameter -> ((String)parameter.getKey()).startsWith("xmlns:")).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    private /* synthetic */ void lambda$calculateExtensionByTopologicalOrder$5(DirectedGraph namespaceDAG, Map allExtensionsByNamespace, String namespace) {
        this.fillDependencyGraph((DirectedGraph<String, DefaultEdge>)namespaceDAG, namespace, allExtensionsByNamespace);
    }
}

