/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory;
import org.mule.runtime.config.api.dsl.processor.AbstractAttributeDefinitionVisitor;
import org.mule.runtime.config.internal.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CollectionBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ComponentModelHelper;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.EagerObjectCreator;
import org.mule.runtime.config.internal.dsl.spring.ExceptionStrategyRefBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.MapBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.MapEntryBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ObjectBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.config.internal.dsl.spring.PropertiesMapBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ReferenceBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.SimpleTypeBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.WrapperElementType;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.exception.ErrorMapping;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.w3c.dom.Element;

public class BeanDefinitionFactory {
    public static final String SPRING_PROTOTYPE_OBJECT = "prototype";
    public static final String SPRING_SINGLETON_OBJECT = "singleton";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String TARGET_TYPE = "targetType";
    public static final String CORE_ERROR_NS = "mule".toUpperCase();
    private final ImmutableSet<ComponentIdentifier> ignoredMuleCoreComponentIdentifiers = ImmutableSet.builder().add((Object)CoreDslConstants.MULE_IDENTIFIER).add((Object)CoreDslConstants.MULE_DOMAIN_IDENTIFIER).add((Object)CoreDslConstants.MULE_EE_DOMAIN_IDENTIFIER).add((Object)ApplicationModel.ERROR_MAPPING_IDENTIFIER).add((Object)ApplicationModel.DESCRIPTION_IDENTIFIER).add((Object)ApplicationModel.ANNOTATIONS_ELEMENT_IDENTIFIER).add((Object)ApplicationModel.DOC_DESCRIPTION_IDENTIFIER).add((Object)ApplicationModel.GLOBAL_PROPERTY_IDENTIFIER).build();
    private Set<ComponentIdentifier> ignoredMuleExtensionComponentIdentifiers;
    private final ImmutableSet<ComponentIdentifier> customBuildersComponentIdentifiers = ImmutableSet.builder().add((Object)ApplicationModel.MULE_PROPERTIES_IDENTIFIER).add((Object)ApplicationModel.MULE_PROPERTY_IDENTIFIER).add((Object)ApplicationModel.OBJECT_IDENTIFIER).build();
    private ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry;
    private BeanDefinitionCreator componentModelProcessor;
    private ErrorTypeRepository errorTypeRepository;
    private ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
    private Set<String> syntheticErrorNamespaces = new HashSet<String>();

    public BeanDefinitionFactory(ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry, ErrorTypeRepository errorTypeRepository) {
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
        this.errorTypeRepository = errorTypeRepository;
        this.componentModelProcessor = this.buildComponentModelProcessorChainOfResponsability();
        this.ignoredMuleExtensionComponentIdentifiers = new HashSet<ComponentIdentifier>();
        this.registerConfigurationPropertyProviders();
    }

    private void registerConfigurationPropertyProviders() {
        ServiceLoader<ConfigurationPropertiesProviderFactory> providerFactories = ServiceLoader.load(ConfigurationPropertiesProviderFactory.class);
        providerFactories.forEach(service -> this.ignoredMuleExtensionComponentIdentifiers.add(service.getSupportedComponentIdentifier()));
    }

    public boolean isComponentIgnored(ComponentIdentifier identifier) {
        return this.ignoredMuleCoreComponentIdentifiers.contains((Object)identifier) || this.ignoredMuleExtensionComponentIdentifiers.contains(identifier);
    }

    public BeanDefinition resolveComponentRecursively(SpringComponentModel parentComponentModel, SpringComponentModel componentModel, BeanDefinitionRegistry registry, BiConsumer<ComponentModel, BeanDefinitionRegistry> componentModelPostProcessor, BiFunction<Element, BeanDefinition, Either<BeanDefinition, BeanReference>> oldParsingMechanism, SpringConfigurationComponentLocator componentLocator) {
        List<ComponentModel> innerComponents = componentModel.getInnerComponents();
        if (!innerComponents.isEmpty()) {
            for (ComponentModel innerComponent : innerComponents) {
                this.resolveComponentRecursively(componentModel, (SpringComponentModel)innerComponent, registry, componentModelPostProcessor, oldParsingMechanism, componentLocator);
            }
        }
        return this.resolveComponent(parentComponentModel, componentModel, registry, componentModelPostProcessor, componentLocator);
    }

    private BeanDefinition resolveComponent(ComponentModel parentComponentModel, SpringComponentModel componentModel, BeanDefinitionRegistry registry, BiConsumer<ComponentModel, BeanDefinitionRegistry> componentDefinitionModelProcessor, SpringConfigurationComponentLocator componentLocator) {
        if (this.isComponentIgnored(componentModel.getIdentifier())) {
            return null;
        }
        if (!componentModel.isEnabled()) {
            componentLocator.addComponentLocation(componentModel.getComponentLocation());
            return null;
        }
        this.resolveComponentBeanDefinition(parentComponentModel, componentModel);
        componentDefinitionModelProcessor.accept(componentModel, registry);
        this.processMuleConfiguration(componentModel, registry);
        this.processMuleSecurityManager(componentModel, registry);
        this.processRaiseError(componentModel);
        this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier()).ifPresent(componentBuildingDefinition -> {
            if (componentModel.getType() != null && Component.class.isAssignableFrom(componentModel.getType())) {
                ComponentModelHelper.addAnnotation(ComponentAnnotations.ANNOTATION_NAME, componentModel.getIdentifier(), componentModel);
                ComponentModelHelper.addAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS, new HashMap<String, String>(componentModel.getParameters()), componentModel);
                List errorMappingComponents = componentModel.getInnerComponents().stream().filter(innerComponent -> ApplicationModel.ERROR_MAPPING_IDENTIFIER.equals(innerComponent.getIdentifier())).collect(Collectors.toList());
                if (!errorMappingComponents.isEmpty()) {
                    ComponentModelHelper.addAnnotation(ErrorMapping.ANNOTATION_ERROR_MAPPINGS, errorMappingComponents.stream().map(innerComponent -> {
                        Map<String, String> parameters = innerComponent.getParameters();
                        ComponentIdentifier source = parameters.containsKey(SOURCE_TYPE) ? ComponentIdentifier.buildFromStringRepresentation(parameters.get(SOURCE_TYPE)) : Errors.ComponentIdentifiers.Handleable.ANY;
                        ErrorType errorType = this.errorTypeRepository.lookupErrorType(source).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not find error '%s'.", source)));
                        SingleErrorTypeMatcher errorTypeMatcher = new SingleErrorTypeMatcher(errorType);
                        ErrorType targetValue = this.resolveErrorType(parameters.get(TARGET_TYPE));
                        return new ErrorMapping(errorTypeMatcher, targetValue);
                    }).collect(Collectors.toList()), componentModel);
                }
                componentLocator.addComponentLocation(componentModel.getComponentLocation());
                ComponentModelHelper.addAnnotation(ComponentAnnotations.ANNOTATION_COMPONENT_CONFIG, componentModel.getConfiguration(), componentModel);
            }
        });
        ComponentModelHelper.addAnnotation(AbstractComponent.LOCATION_KEY, componentModel.getComponentLocation(), componentModel);
        BeanDefinition beanDefinition = componentModel.getBeanDefinition();
        return beanDefinition;
    }

    private void processRaiseError(ComponentModel componentModel) {
        if (componentModel.getIdentifier().equals(CoreDslConstants.RAISE_ERROR_IDENTIFIER)) {
            this.resolveErrorType(componentModel.getParameters().get("type"));
        }
    }

    private ErrorType resolveErrorType(String representation) {
        String identifier;
        String namespace;
        int separator = representation.indexOf(":");
        if (separator > 0) {
            namespace = representation.substring(0, separator).toUpperCase();
            identifier = representation.substring(separator + 1).toUpperCase();
        } else {
            namespace = CORE_ERROR_NS;
            identifier = representation.toUpperCase();
        }
        ComponentIdentifier errorIdentifier = ComponentIdentifier.builder().namespace(namespace).name(identifier).build();
        if (CORE_ERROR_NS.equals(namespace)) {
            return this.errorTypeRepository.lookupErrorType(errorIdentifier).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There's no MULE error named '%s'.", identifier))));
        }
        if (this.errorTypeRepository.getErrorNamespaces().contains(namespace) && !this.syntheticErrorNamespaces.contains(namespace)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Cannot use error type '%s:%s': namespace already exists.", namespace, identifier)));
        }
        if (this.syntheticErrorNamespaces.contains(namespace)) {
            Optional<ErrorType> optionalErrorType = this.errorTypeRepository.lookupErrorType(errorIdentifier);
            if (optionalErrorType.isPresent()) {
                return optionalErrorType.get();
            }
        } else {
            this.syntheticErrorNamespaces.add(namespace);
        }
        return this.errorTypeRepository.addErrorType(errorIdentifier, this.errorTypeRepository.getAnyErrorType());
    }

    private void processMuleConfiguration(ComponentModel componentModel, BeanDefinitionRegistry registry) {
        if (componentModel.getIdentifier().equals(CoreDslConstants.CONFIGURATION_IDENTIFIER)) {
            AtomicReference expressionLanguage = new AtomicReference();
            componentModel.getInnerComponents().stream().forEach(childComponentModel -> {
                if (CommonBeanDefinitionCreator.areMatchingTypes(MVELExpressionLanguage.class, childComponentModel.getType())) {
                    expressionLanguage.set(((SpringComponentModel)childComponentModel).getBeanDefinition());
                }
            });
            String defaultObjectSerializer = componentModel.getParameters().get("defaultObjectSerializer-ref");
            if (defaultObjectSerializer != null && defaultObjectSerializer != "_muleDefaultObjectSerializer") {
                registry.removeBeanDefinition("_muleDefaultObjectSerializer");
                registry.registerAlias(defaultObjectSerializer, "_muleDefaultObjectSerializer");
            }
            if (expressionLanguage.get() != null) {
                registry.registerBeanDefinition("_muleExpressionLanguage", (BeanDefinition)expressionLanguage.get());
            }
        }
    }

    private void processMuleSecurityManager(ComponentModel componentModel, BeanDefinitionRegistry registry) {
        if (componentModel.getIdentifier().equals(ApplicationModel.SECURITY_MANAGER_IDENTIFIER)) {
            componentModel.getInnerComponents().stream().forEach(childComponentModel -> {
                String identifier = childComponentModel.getIdentifier().getName();
                if (identifier.equals("password-encryption-strategy") || identifier.equals("secret-key-encryption-strategy")) {
                    registry.registerBeanDefinition(childComponentModel.getNameAttribute(), ((SpringComponentModel)childComponentModel).getBeanDefinition());
                }
            });
        }
    }

    private void resolveComponentBeanDefinition(ComponentModel parentComponentModel, SpringComponentModel componentModel) {
        Optional<ComponentBuildingDefinition<?>> buildingDefinitionOptional = this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier());
        if (buildingDefinitionOptional.isPresent() || this.customBuildersComponentIdentifiers.contains((Object)componentModel.getIdentifier())) {
            this.componentModelProcessor.processRequest(new CreateBeanDefinitionRequest(parentComponentModel, componentModel, buildingDefinitionOptional.orElse(null)));
        } else {
            boolean isWrapperComponent = this.isWrapperComponent(componentModel.getIdentifier(), Optional.of(parentComponentModel.getIdentifier()));
            if (!isWrapperComponent) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("No component building definition for element %s. It may be that there's a dependency missing to the project that handle that extension.", componentModel.getIdentifier())));
            }
            this.processComponentWrapper(componentModel);
        }
    }

    private void processComponentWrapper(SpringComponentModel componentModel) {
        ComponentBuildingDefinition<?> parentBuildingDefinition = this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getParent().getIdentifier()).get();
        Map<String, WrapperElementType> wrapperIdentifierAndTypeMap = this.getWrapperIdentifierAndTypeMap(parentBuildingDefinition);
        WrapperElementType wrapperElementType = wrapperIdentifierAndTypeMap.get(componentModel.getIdentifier().getName());
        if (wrapperElementType.equals((Object)WrapperElementType.SINGLE)) {
            if (componentModel.getInnerComponents().isEmpty()) {
                String location = componentModel.getComponentLocation() != null ? componentModel.getComponentLocation().getLocation() : "";
                throw new IllegalStateException(String.format("Element [%s] located at [%s] does not have any child element declared, but one is required.", componentModel.getIdentifier(), location));
            }
        } else {
            throw new IllegalStateException(String.format("Element %s does not have a building definition and it should since it's of type %s", new Object[]{componentModel.getIdentifier(), wrapperElementType}));
        }
        SpringComponentModel firstComponentModel = (SpringComponentModel)componentModel.getInnerComponents().get(0);
        componentModel.setType(firstComponentModel.getType());
        componentModel.setBeanDefinition(firstComponentModel.getBeanDefinition());
        componentModel.setBeanReference(firstComponentModel.getBeanReference());
    }

    private BeanDefinitionCreator buildComponentModelProcessorChainOfResponsability() {
        EagerObjectCreator eagerObjectCreator = new EagerObjectCreator();
        ObjectBeanDefinitionCreator objectBeanDefinitionCreator = new ObjectBeanDefinitionCreator();
        ExceptionStrategyRefBeanDefinitionCreator exceptionStrategyRefBeanDefinitionCreator = new ExceptionStrategyRefBeanDefinitionCreator();
        PropertiesMapBeanDefinitionCreator propertiesMapBeanDefinitionCreator = new PropertiesMapBeanDefinitionCreator();
        ReferenceBeanDefinitionCreator referenceBeanDefinitionCreator = new ReferenceBeanDefinitionCreator();
        SimpleTypeBeanDefinitionCreator simpleTypeBeanDefinitionCreator = new SimpleTypeBeanDefinitionCreator();
        CollectionBeanDefinitionCreator collectionBeanDefinitionCreator = new CollectionBeanDefinitionCreator();
        MapEntryBeanDefinitionCreator mapEntryBeanDefinitionCreator = new MapEntryBeanDefinitionCreator();
        MapBeanDefinitionCreator mapBeanDefinitionCreator = new MapBeanDefinitionCreator();
        CommonBeanDefinitionCreator commonComponentModelProcessor = new CommonBeanDefinitionCreator(this.objectFactoryClassRepository);
        eagerObjectCreator.setNext(objectBeanDefinitionCreator);
        objectBeanDefinitionCreator.setNext(propertiesMapBeanDefinitionCreator);
        propertiesMapBeanDefinitionCreator.setNext(exceptionStrategyRefBeanDefinitionCreator);
        exceptionStrategyRefBeanDefinitionCreator.setNext(referenceBeanDefinitionCreator);
        referenceBeanDefinitionCreator.setNext(simpleTypeBeanDefinitionCreator);
        simpleTypeBeanDefinitionCreator.setNext(collectionBeanDefinitionCreator);
        collectionBeanDefinitionCreator.setNext(mapEntryBeanDefinitionCreator);
        mapEntryBeanDefinitionCreator.setNext(mapBeanDefinitionCreator);
        mapBeanDefinitionCreator.setNext(commonComponentModelProcessor);
        return eagerObjectCreator;
    }

    public boolean hasDefinition(ComponentIdentifier componentIdentifier, Optional<ComponentIdentifier> parentComponentModelOptional) {
        return this.isComponentIgnored(componentIdentifier) || this.customBuildersComponentIdentifiers.contains((Object)componentIdentifier) || this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentIdentifier).isPresent() || this.isWrapperComponent(componentIdentifier, parentComponentModelOptional);
    }

    public boolean isWrapperComponent(ComponentIdentifier componentModel, Optional<ComponentIdentifier> parentComponentModelOptional) {
        if (!parentComponentModelOptional.isPresent()) {
            return false;
        }
        Optional<ComponentBuildingDefinition<?>> buildingDefinitionOptional = this.componentBuildingDefinitionRegistry.getBuildingDefinition(parentComponentModelOptional.get());
        if (!buildingDefinitionOptional.isPresent()) {
            return false;
        }
        Map<String, WrapperElementType> wrapperIdentifierAndTypeMap = this.getWrapperIdentifierAndTypeMap(buildingDefinitionOptional.get());
        return wrapperIdentifierAndTypeMap.containsKey(componentModel.getName());
    }

    private <T> Map<String, WrapperElementType> getWrapperIdentifierAndTypeMap(ComponentBuildingDefinition<T> buildingDefinition) {
        final HashMap<String, WrapperElementType> wrapperIdentifierAndTypeMap = new HashMap<String, WrapperElementType>();
        AbstractAttributeDefinitionVisitor wrapperIdentifiersCollector = new AbstractAttributeDefinitionVisitor(){

            @Override
            public void onComplexChildCollection(Class<?> type, Optional<String> wrapperIdentifierOptional) {
                wrapperIdentifierOptional.ifPresent(wrapperIdentifier -> wrapperIdentifierAndTypeMap.put(wrapperIdentifier, WrapperElementType.COLLECTION));
            }

            @Override
            public void onComplexChild(Class<?> type, Optional<String> wrapperIdentifierOptional, Optional<String> childIdentifier) {
                wrapperIdentifierOptional.ifPresent(wrapperIdentifier -> wrapperIdentifierAndTypeMap.put(wrapperIdentifier, WrapperElementType.SINGLE));
            }

            @Override
            public void onComplexChildMap(Class<?> keyType, Class<?> valueType, String wrapperIdentifier) {
                wrapperIdentifierAndTypeMap.put(wrapperIdentifier, WrapperElementType.MAP);
            }

            @Override
            public void onMultipleValues(KeyAttributeDefinitionPair[] definitions) {
                for (KeyAttributeDefinitionPair attributeDefinition : definitions) {
                    attributeDefinition.getAttributeDefinition().accept(this);
                }
            }
        };
        Consumer<AttributeDefinition> collectWrappersConsumer = attributeDefinition -> attributeDefinition.accept(wrapperIdentifiersCollector);
        buildingDefinition.getSetterParameterDefinitions().stream().map(setterAttributeDefinition -> setterAttributeDefinition.getAttributeDefinition()).forEach(collectWrappersConsumer);
        buildingDefinition.getConstructorAttributeDefinition().stream().forEach(collectWrappersConsumer);
        return wrapperIdentifierAndTypeMap;
    }
}

