/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.transaction;

import org.apache.commons.collections.ArrayStack;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.internal.processor.DelegateTransaction;
import org.mule.runtime.core.privileged.transaction.xa.IllegalTransactionStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionCoordination {
    protected static final Logger logger = LoggerFactory.getLogger(TransactionCoordination.class);
    private static final TransactionCoordination instance = new TransactionCoordination();
    private final ThreadLocal<Transaction> transactions = new ThreadLocal();
    private final ThreadLocal<Transaction> suspendedTransaction = new ThreadLocal();
    private final ThreadLocal<ArrayStack> isolatedTransactions = new ThreadLocal();
    private final Object txCounterLock = new Object();
    private int txCounter = 0;

    private TransactionCoordination() {
    }

    public static TransactionCoordination getInstance() {
        return instance;
    }

    public Transaction getTransaction() {
        return this.transactions.get();
    }

    public void unbindTransaction(Transaction transaction) throws TransactionException {
        Transaction oldTx = this.transactions.get();
        try {
            if (oldTx != null && !oldTx.equals(transaction)) {
                throw new IllegalTransactionStateException(CoreMessages.transactionCannotUnbind());
            }
        }
        finally {
            this.transactions.set(null);
            this.logTransactionUnbound(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logTransactionUnbound(Transaction transaction) {
        int txCounter = 0;
        Object object = this.txCounterLock;
        synchronized (object) {
            if (this.txCounter > 0) {
                txCounter = --this.txCounter;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Unbinding transaction (" + txCounter + ") " + transaction);
        }
    }

    public void bindTransaction(Transaction transaction) throws TransactionException {
        Transaction oldTx = this.transactions.get();
        if (oldTx != null && !(oldTx instanceof DelegateTransaction)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAlreadyBound());
        }
        if (oldTx != null && oldTx instanceof DelegateTransaction) {
            DelegateTransaction delegateTransaction = (DelegateTransaction)oldTx;
            if (!delegateTransaction.supportsInnerTransaction(transaction)) {
                throw new IllegalTransactionStateException(CoreMessages.transactionAlreadyBound());
            }
            return;
        }
        this.transactions.set(transaction);
        this.logTransactionBound(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logTransactionBound(Transaction transaction) {
        int txCounter;
        Object object = this.txCounterLock;
        synchronized (object) {
            txCounter = ++this.txCounter;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Binding new transaction (" + txCounter + ") " + transaction);
        }
    }

    public void resumeXaTransactionIfAvailable() {
        try {
            Transaction tx = this.suspendedTransaction.get();
            if (tx != null) {
                this.resumeSuspendedTransaction();
            }
        }
        catch (TransactionException e) {
            logger.error("Failure resuming suspended transaction", (Throwable)e);
        }
    }

    public void commitCurrentTransaction() {
        Transaction tx = this.transactions.get();
        if (tx != null) {
            try {
                tx.commit();
            }
            catch (TransactionException e) {
                logger.error("Cannot commit current transaction", (Throwable)e);
            }
        }
    }

    public void rollbackCurrentTransaction() {
        Transaction tx = this.transactions.get();
        if (tx != null) {
            try {
                tx.rollback();
            }
            catch (TransactionException e) {
                logger.error("Cannot rollback current transaction", (Throwable)e);
            }
        }
    }

    public void resolveTransaction() throws TransactionException {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx.isRollbackOnly()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Transaction has been marked rollbackOnly, rolling it back: " + tx);
            }
            tx.rollback();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Committing transaction " + tx);
            }
            tx.commit();
        }
    }

    public void suspendCurrentTransaction() throws TransactionException {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug("Suspending " + tx);
        }
        tx.suspend();
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully suspended " + tx);
            logger.debug("Unbinding the following TX from the current context: " + tx);
        }
        TransactionCoordination.getInstance().unbindTransaction(tx);
        this.suspendedTransaction.set(tx);
    }

    public void resumeSuspendedTransaction() throws TransactionException {
        Transaction tx = this.suspendedTransaction.get();
        if (logger.isDebugEnabled()) {
            logger.debug("Re-binding and Resuming " + tx);
        }
        TransactionCoordination.getInstance().bindTransaction(tx);
        this.suspendedTransaction.remove();
        tx.resume();
    }

    public void clear() {
        this.suspendedTransaction.remove();
        this.transactions.remove();
        if (this.isolatedTransactions.get() != null) {
            this.isolatedTransactions.get().clear();
        }
        this.isolatedTransactions.remove();
    }

    public void isolateTransaction() {
        Transaction currentTransaction = this.transactions.get();
        if (currentTransaction != null) {
            if (this.isolatedTransactions.get() == null) {
                this.isolatedTransactions.set(new ArrayStack());
            }
            this.isolatedTransactions.get().push((Object)this.transactions.get());
            this.transactions.set(null);
        }
    }

    public void restoreIsolatedTransaction() {
        if (this.isolatedTransactions.get() != null && !this.isolatedTransactions.get().isEmpty()) {
            this.transactions.set((Transaction)this.isolatedTransactions.get().pop());
        }
    }

    public static boolean isTransactionActive() {
        return TransactionCoordination.getInstance().getTransaction() != null;
    }
}

