/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import java.util.concurrent.RejectedExecutionException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.AbstractPipeline;
import org.mule.runtime.core.internal.construct.FlowBackPressureException;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;

class BackPressureStrategySelector {
    private static int EVENT_LOOP_SCHEDULER_BUSY_RETRY_INTERVAL_MS = 2;
    private final AbstractPipeline abstractPipeline;
    private final MessagingExceptionResolver exceptionResolver;

    public BackPressureStrategySelector(AbstractPipeline abstractPipeline) {
        this.abstractPipeline = abstractPipeline;
        this.exceptionResolver = new MessagingExceptionResolver(abstractPipeline);
    }

    protected void checkWithWaitStrategy(CoreEvent event) throws FlowBackPressureException {
        boolean accepted = false;
        while (!accepted) {
            try {
                this.abstractPipeline.getProcessingStrategy().checkBackpressureAccepting(event);
                accepted = true;
            }
            catch (RejectedExecutionException ree) {
                try {
                    Thread.sleep(EVENT_LOOP_SCHEDULER_BUSY_RETRY_INTERVAL_MS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new FlowBackPressureException(this.abstractPipeline.getName(), (Throwable)ree);
                }
            }
        }
    }

    protected void checkWithFailDropStrategy(CoreEvent event) throws FlowBackPressureException {
        if (!this.abstractPipeline.getProcessingStrategy().checkBackpressureEmitting(event)) {
            throw new FlowBackPressureException(this.abstractPipeline.getName());
        }
    }

    public void check(CoreEvent event) throws FlowBackPressureException {
        if (this.abstractPipeline.getSource().getBackPressureStrategy() == MessageSource.BackPressureStrategy.WAIT) {
            this.checkWithWaitStrategy(event);
        } else {
            this.checkWithFailDropStrategy(event);
        }
    }
}

