/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Optional;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.policy.PolicyChain;
import org.mule.runtime.core.api.policy.PolicyInstance;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.lifecycle.DefaultLifecycleManager;
import org.mule.runtime.core.internal.management.stats.DefaultFlowConstructStatistics;
import org.mule.runtime.core.internal.processor.strategy.TransactionAwareProactorStreamEmitterProcessingStrategyFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@NoExtend
public class DefaultPolicyInstance
extends AbstractComponent
implements PolicyInstance,
FlowConstruct,
MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPolicyInstance.class);
    private ProcessingStrategy processingStrategy;
    private String name;
    private PolicyChain operationPolicyChain;
    private PolicyChain sourcePolicyChain;
    private FlowConstructStatistics flowConstructStatistics;
    private MuleContext muleContext;
    private final DefaultLifecycleManager<DefaultPolicyInstance> lifecycleStateManager = new DefaultLifecycleManager<DefaultPolicyInstance>("proxy-policy-" + UUID.getUUID(), this);

    @Override
    public void initialise() throws InitialisationException {
        this.flowConstructStatistics = new DefaultFlowConstructStatistics("policy", this.getName());
        this.processingStrategy = this.defaultProcessingStrategy().create(this.muleContext, this.getName());
        if (this.operationPolicyChain != null) {
            this.operationPolicyChain.setProcessingStrategy(this.processingStrategy);
        }
        if (this.sourcePolicyChain != null) {
            this.sourcePolicyChain.setProcessingStrategy(this.processingStrategy);
        }
        LifecycleUtils.initialiseIfNeeded(this.operationPolicyChain, this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.sourcePolicyChain, this.muleContext);
        this.lifecycleStateManager.fireInitialisePhase((phaseNam, object) -> {});
    }

    private ProcessingStrategyFactory defaultProcessingStrategy() {
        ProcessingStrategyFactory defaultProcessingStrategyFactory = this.getMuleContext().getConfiguration().getDefaultProcessingStrategyFactory();
        if (defaultProcessingStrategyFactory == null) {
            return new TransactionAwareProactorStreamEmitterProcessingStrategyFactory();
        }
        return defaultProcessingStrategyFactory;
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processingStrategy);
        LifecycleUtils.startIfNeeded(this.operationPolicyChain);
        LifecycleUtils.startIfNeeded(this.sourcePolicyChain);
        this.lifecycleStateManager.fireStartPhase((phaseNam, object) -> {});
    }

    @Override
    public FlowExceptionHandler getExceptionListener() {
        return new FlowExceptionHandler(){

            @Override
            public CoreEvent handleException(Exception exception, CoreEvent event) {
                return null;
            }

            @Override
            public Publisher<CoreEvent> apply(Exception exception) {
                return Mono.error((Throwable)exception);
            }
        };
    }

    @Override
    public FlowConstructStatistics getStatistics() {
        return this.flowConstructStatistics;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public String getUniqueIdString() {
        return this.muleContext.getUniqueIdString();
    }

    @Override
    public String getServerId() {
        return this.muleContext.getId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleStateManager.getState();
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.operationPolicyChain, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.sourcePolicyChain, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.processingStrategy, LOGGER);
        this.lifecycleStateManager.fireDisposePhase((phaseNam, object) -> {});
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.operationPolicyChain);
        LifecycleUtils.stopIfNeeded(this.sourcePolicyChain);
        LifecycleUtils.stopIfNeeded(this.processingStrategy);
        this.lifecycleStateManager.fireStopPhase((phaseNam, object) -> {});
    }

    public void setOperationPolicyChain(PolicyChain request) {
        this.operationPolicyChain = request;
    }

    public void setSourcePolicyChain(PolicyChain source) {
        this.sourcePolicyChain = source;
    }

    @Override
    public Optional<PolicyChain> getSourcePolicyChain() {
        return Optional.ofNullable(this.sourcePolicyChain);
    }

    @Override
    public Optional<PolicyChain> getOperationPolicyChain() {
        return Optional.ofNullable(this.operationPolicyChain);
    }

    @Override
    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }
}

