/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.FlowConstructNotification;
import org.mule.runtime.api.notification.FlowConstructNotificationListener;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyProvider;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.CompositeOperationPolicy;
import org.mule.runtime.core.internal.policy.CompositeSourcePolicy;
import org.mule.runtime.core.internal.policy.DefaultOperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.DefaultSourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.NoSourcePolicy;
import org.mule.runtime.core.internal.policy.NullPolicyProvider;
import org.mule.runtime.core.internal.policy.OperationParametersProcessor;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.policy.PolicyPointcutParametersManager;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.policy.api.OperationPolicyPointcutParametersFactory;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.runtime.policy.api.SourcePolicyPointcutParametersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPolicyManager
implements PolicyManager,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPolicyManager.class);
    private static final OperationPolicy NO_POLICY_OPERATION = (operationEvent, operationExecutionFunction, opParamProcessor, componentLocation) -> operationExecutionFunction.execute(opParamProcessor.getOperationParameters(), operationEvent);
    private MuleContext muleContext;
    private Registry registry;
    private final AtomicBoolean isPoliciesAvailable = new AtomicBoolean(false);
    private final Executor syncExecutor = Runnable::run;
    private final Cache<String, SourcePolicy> noPolicySourceInstances = Caffeine.newBuilder().executor(this.syncExecutor).removalListener((key, value, cause) -> LifecycleUtils.disposeIfNeeded(value, LOGGER)).build();
    private final Cache<Pair<String, List<Policy>>, SourcePolicy> sourcePolicyInnerCache = Caffeine.newBuilder().executor(this.syncExecutor).removalListener((key, value, cause) -> LifecycleUtils.disposeIfNeeded(value, LOGGER)).build();
    private final Cache<List<Policy>, OperationPolicy> operationPolicyInnerCache = Caffeine.newBuilder().executor(this.syncExecutor).removalListener((key, value, cause) -> LifecycleUtils.disposeIfNeeded(value, LOGGER)).build();
    private final Cache<Pair<String, PolicyPointcutParameters>, SourcePolicy> sourcePolicyOuterCache = Caffeine.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    private final Cache<Pair<ComponentIdentifier, PolicyPointcutParameters>, OperationPolicy> operationPolicyOuterCache = Caffeine.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    private PolicyProvider policyProvider;
    private OperationPolicyProcessorFactory operationPolicyProcessorFactory;
    private SourcePolicyProcessorFactory sourcePolicyProcessorFactory;
    private PolicyPointcutParametersManager policyPointcutParametersManager;

    public static boolean isNoPolicyOperation(OperationPolicy policy) {
        return NO_POLICY_OPERATION.equals(policy);
    }

    @Override
    public SourcePolicy createSourcePolicyInstance(Component source, CoreEvent sourceEvent, ReactiveProcessor flowExecutionProcessor, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        ComponentIdentifier sourceIdentifier = source.getLocation().getComponentIdentifier().getIdentifier();
        if (!this.isPoliciesAvailable.get()) {
            SourcePolicy policy = (SourcePolicy)this.noPolicySourceInstances.getIfPresent((Object)source.getLocation().getRootContainerName());
            if (policy != null) {
                return policy;
            }
            return (SourcePolicy)this.noPolicySourceInstances.get((Object)source.getLocation().getRootContainerName(), k -> new NoSourcePolicy(flowExecutionProcessor));
        }
        PolicyPointcutParameters sourcePointcutParameters = (PolicyPointcutParameters)((InternalEvent)sourceEvent).getInternalParameter("policy.sourcePointcutParameters");
        Pair<String, PolicyPointcutParameters> policyKey = new Pair<String, PolicyPointcutParameters>(source.getLocation().getRootContainerName(), sourcePointcutParameters);
        SourcePolicy policy = (SourcePolicy)this.sourcePolicyOuterCache.getIfPresent(policyKey);
        if (policy != null) {
            return policy;
        }
        return (SourcePolicy)this.sourcePolicyOuterCache.get(policyKey, outerKey -> (SourcePolicy)this.sourcePolicyInnerCache.get(new Pair<String, List<Policy>>(source.getLocation().getRootContainerName(), this.policyProvider.findSourceParameterizedPolicies(sourcePointcutParameters)), innerKey -> ((List)innerKey.getSecond()).isEmpty() ? new NoSourcePolicy(flowExecutionProcessor) : new CompositeSourcePolicy((List)innerKey.getSecond(), flowExecutionProcessor, this.lookupSourceParametersTransformer(sourceIdentifier), this.sourcePolicyProcessorFactory, exception -> new MessagingExceptionResolver(source).resolve((MessagingException)exception, this.muleContext))));
    }

    @Override
    public PolicyPointcutParameters addSourcePointcutParametersIntoEvent(Component source, TypedValue<?> attributes, InternalEvent.Builder eventBuilder) {
        PolicyPointcutParameters sourcePolicyParams = this.policyPointcutParametersManager.createSourcePointcutParameters(source, attributes);
        eventBuilder.addInternalParameter("policy.sourcePointcutParameters", sourcePolicyParams);
        return sourcePolicyParams;
    }

    @Override
    public OperationPolicy createOperationPolicy(Component operation, CoreEvent event, OperationParametersProcessor operationParameters) {
        if (!this.isPoliciesAvailable.get()) {
            return NO_POLICY_OPERATION;
        }
        PolicyPointcutParameters operationPointcutParameters = this.policyPointcutParametersManager.createOperationPointcutParameters(operation, event, operationParameters.getOperationParameters());
        ComponentIdentifier operationIdentifier = operation.getLocation().getComponentIdentifier().getIdentifier();
        Pair<ComponentIdentifier, PolicyPointcutParameters> policyKey = new Pair<ComponentIdentifier, PolicyPointcutParameters>(operationIdentifier, operationPointcutParameters);
        OperationPolicy policy = (OperationPolicy)this.operationPolicyOuterCache.getIfPresent(policyKey);
        if (policy != null) {
            return policy;
        }
        return (OperationPolicy)this.operationPolicyOuterCache.get(policyKey, outerKey -> (OperationPolicy)this.operationPolicyInnerCache.get(this.policyProvider.findOperationParameterizedPolicies((PolicyPointcutParameters)outerKey.getSecond()), innerKey -> innerKey.isEmpty() ? NO_POLICY_OPERATION : new CompositeOperationPolicy((List<Policy>)innerKey, this.lookupOperationParametersTransformer((ComponentIdentifier)outerKey.getFirst()), this.operationPolicyProcessorFactory)));
    }

    private Optional<OperationPolicyParametersTransformer> lookupOperationParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.registry.lookupAllByType(OperationPolicyParametersTransformer.class).stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    private Optional<SourcePolicyParametersTransformer> lookupSourceParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.registry.lookupAllByType(SourcePolicyParametersTransformer.class).stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    @Override
    public void initialise() throws InitialisationException {
        this.operationPolicyProcessorFactory = new DefaultOperationPolicyProcessorFactory();
        this.sourcePolicyProcessorFactory = new DefaultSourcePolicyProcessorFactory();
        this.policyProvider = this.registry.lookupByType(PolicyProvider.class).orElse(new NullPolicyProvider());
        if (this.muleContext.getArtifactType().equals((Object)ArtifactType.APP)) {
            this.policyProvider.onPoliciesChanged(() -> {
                this.evictCaches();
                this.isPoliciesAvailable.set(this.policyProvider.isPoliciesAvailable());
            });
        }
        this.isPoliciesAvailable.set(this.policyProvider.isPoliciesAvailable());
        this.policyPointcutParametersManager = new PolicyPointcutParametersManager(this.registry.lookupAllByType(SourcePolicyPointcutParametersFactory.class), this.registry.lookupAllByType(OperationPolicyPointcutParametersFactory.class));
        this.muleContext.getNotificationManager().addListener(new FlowConstructNotificationListener<FlowConstructNotification>(){

            @Override
            public boolean isBlocking() {
                return false;
            }

            @Override
            public void onNotification(FlowConstructNotification notification) {
                if (Integer.parseInt(notification.getAction().getIdentifier()) == 1506) {
                    LOGGER.debug("Invalidating flow from caches named {}", (Object)notification.getResourceIdentifier());
                    DefaultPolicyManager.this.invalidateDisposedFlowFromCaches(notification.getResourceIdentifier());
                }
            }
        });
    }

    private void invalidateDisposedFlowFromCaches(String flowName) {
        this.noPolicySourceInstances.invalidate((Object)flowName);
        this.sourcePolicyOuterCache.asMap().keySet().stream().filter(pair -> ((String)pair.getFirst()).equals(flowName)).forEach(matchingPair -> this.sourcePolicyOuterCache.invalidate(matchingPair));
        this.sourcePolicyInnerCache.asMap().keySet().stream().filter(pair -> ((String)pair.getFirst()).equals(flowName)).forEach(matchingPair -> this.sourcePolicyInnerCache.invalidate(matchingPair));
    }

    @Override
    public void dispose() {
        this.evictCaches();
    }

    private void evictCaches() {
        this.noPolicySourceInstances.invalidateAll();
        this.sourcePolicyOuterCache.invalidateAll();
        this.operationPolicyOuterCache.invalidateAll();
        this.sourcePolicyInnerCache.invalidateAll();
        this.operationPolicyInnerCache.invalidateAll();
    }

    @Inject
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

