/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.internal.streaming.CursorUtils;
import org.mule.runtime.core.internal.streaming.IdentifiableCursorProvider;
import org.mule.runtime.core.internal.streaming.IdentifiableCursorProviderDecorator;
import org.mule.runtime.core.internal.streaming.ManagedCursorProvider;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;
import org.mule.runtime.core.internal.streaming.bytes.ManagedCursorStreamProvider;
import org.mule.runtime.core.internal.streaming.object.ManagedCursorIteratorProvider;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorManager {
    public static final boolean STREAMING_VERBOSE = Boolean.getBoolean("mule.streaming.verbose");
    private static final Logger LOGGER = LoggerFactory.getLogger(CursorManager.class);
    private final LoadingCache<BaseEventContext, EventStreamingState> registry = Caffeine.newBuilder().removalListener((context, state, cause) -> EventStreamingState.access$400((EventStreamingState)state)).build(context -> {
        this.hookEventTermination((BaseEventContext)context);
        return new EventStreamingState();
    });
    private final MutableStreamingStatistics statistics;
    private final StreamingGhostBuster ghostBuster;

    public CursorManager(MutableStreamingStatistics statistics, StreamingGhostBuster ghostBuster) {
        this.statistics = statistics;
        this.ghostBuster = ghostBuster;
    }

    public CursorProvider manage(CursorProvider provider, BaseEventContext ownerContext) {
        ManagedCursorProvider managedProvider;
        CursorProvider innerDelegate = CursorUtils.unwrap(provider);
        IdentifiableCursorProviderDecorator<CursorStream> identifiable = IdentifiableCursorProviderDecorator.of(provider);
        if (innerDelegate instanceof CursorStreamProvider) {
            managedProvider = new ManagedCursorStreamProvider((IdentifiableCursorProvider<CursorStream>)identifiable, this.statistics);
        } else if (innerDelegate instanceof CursorIteratorProvider) {
            managedProvider = new ManagedCursorIteratorProvider((IdentifiableCursorProvider<CursorIterator>)identifiable, this.statistics);
        } else {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Unknown cursor provider type: " + innerDelegate.getClass().getName()));
        }
        return ((EventStreamingState)this.registry.get((Object)ownerContext)).addProvider(managedProvider);
    }

    private void terminated(BaseEventContext context) {
        this.registry.invalidate((Object)context);
    }

    private void hookEventTermination(BaseEventContext ownerContext) {
        ownerContext.onTerminated((response, throwable) -> this.terminated(ownerContext));
    }

    private class EventStreamingState {
        private final AtomicBoolean disposed = new AtomicBoolean(false);
        private final Cache<Integer, WeakReference<ManagedCursorProvider>> providers = Caffeine.newBuilder().build();

        private EventStreamingState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ManagedCursorProvider addProvider(ManagedCursorProvider provider) {
            int id = provider.getId();
            ManagedCursorProvider managedProvider = this.getOrAddManagedProvider(provider, id);
            if (managedProvider == null) {
                CursorProvider cursorProvider = CursorUtils.unwrap(provider);
                synchronized (cursorProvider) {
                    managedProvider = this.getOrAddManagedProvider(provider, id);
                    if (managedProvider == null) {
                        this.providers.invalidate((Object)id);
                        managedProvider = this.getOrAddManagedProvider(provider, id);
                    }
                }
            }
            return managedProvider;
        }

        private ManagedCursorProvider getOrAddManagedProvider(ManagedCursorProvider provider, int hash) {
            return (ManagedCursorProvider)((WeakReference)this.providers.get((Object)hash, k -> {
                if (STREAMING_VERBOSE) {
                    CursorProvider innerDelegate = CursorUtils.unwrap(provider);
                    Optional<ComponentLocation> originatingLocation = provider.getOriginatingLocation();
                    LOGGER.info("Added ManagedCursorProvider: {} for delegate: {} opened by: {}", new Object[]{k, System.identityHashCode(innerDelegate), originatingLocation.map(ComponentLocation::getLocation).orElse("unknown")});
                }
                return CursorManager.this.ghostBuster.track(provider);
            })).get();
        }

        private void dispose() {
            if (this.disposed.compareAndSet(false, true)) {
                this.providers.asMap().forEach((hash, weakReference) -> {
                    ManagedCursorProvider provider = (ManagedCursorProvider)weakReference.get();
                    if (provider != null) {
                        weakReference.clear();
                        provider.releaseResources();
                    }
                });
            }
        }
    }
}

