/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public final class ParameterModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) {
        new ValidatorDelegate().validate(model, problemsReporter);
    }

    private class ValidatorDelegate
    implements ExtensionModelValidator {
        private ProblemsReporter problemsReporter;
        private Set<String> validatedComponentIdContainers = new HashSet<String>();

        private ValidatorDelegate() {
        }

        @Override
        public void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
            this.problemsReporter = problemsReporter;
            new ExtensionWalker(){

                @Override
                public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                    String ownerName = owner.getName();
                    String ownerModelType = NameUtils.getComponentModelTypeName(owner);
                    ValidatorDelegate.this.validateParameter(model, ownerName, ownerModelType, owner);
                    ValidatorDelegate.this.validateOAuthParameter(model, ownerName, ownerModelType);
                }
            }.walk(extensionModel);
        }

        private void validateParameter(ParameterModel parameterModel, String ownerName, String ownerModelType, ParameterizedModel owner) {
            if (parameterModel.getType() == null) {
                this.addError(parameterModel, "Parameter '%s' in the %s '%s' must provide a type", parameterModel.getName(), ownerModelType, ownerName);
            }
            if (ExtensionModelUtils.getDefaultValue(parameterModel).isPresent()) {
                this.validateDefaultValue(parameterModel, ownerName, ownerModelType);
            }
            if (parameterModel.isComponentId()) {
                this.validateComponentId(parameterModel, ownerName, ownerModelType, owner);
            }
        }

        private void validateDefaultValue(final ParameterModel parameterModel, final String ownerName, final String ownerModelType) {
            if (parameterModel.isOverrideFromConfig() && !ownerModelType.equals("configuration") && !ownerModelType.equals("connection provider")) {
                this.addError(parameterModel, "Parameter '%s' in the %s '%s' is declared as a config override, and must not provide a default value since one is already provided by the value declared in the config parameter", parameterModel.getName(), ownerModelType, ownerName);
            } else if (parameterModel.isRequired()) {
                this.addError(parameterModel, "Parameter '%s' in the %s '%s' is required, and must not provide a default value", parameterModel.getName(), ownerModelType, ownerName);
            }
            if (!ExtensionModelUtils.hasExpressionDefaultValue(parameterModel)) {
                parameterModel.getType().accept(new MetadataTypeVisitor(){

                    @Override
                    public void visitString(StringType type) {
                        type.getAnnotation(EnumAnnotation.class).ifPresent(enumAnnotation -> {
                            String stringValue;
                            List values = Stream.of(enumAnnotation.getValues()).map(Object::toString).collect(Collectors.toList());
                            if (!values.contains(stringValue = parameterModel.getDefaultValue().toString())) {
                                ValidatorDelegate.this.addError(parameterModel, "Parameter '%s' in the %s '%s' has '%s' as default value which is not listed as an available option (i.e.: %s).", new Object[]{parameterModel.getName(), ownerModelType, ownerName, stringValue, String.join((CharSequence)", ", values)});
                            }
                        });
                    }
                });
            }
        }

        private void validateComponentId(ParameterModel parameterModel, String ownerName, String ownerModelType, ParameterizedModel owner) {
            if (!parameterModel.isRequired()) {
                this.addError(parameterModel, "Parameter '%s' in the %s '%s' is declared as a Component ID, but is also marked as Optional. Only a required parameter can serve as Component ID", parameterModel.getName(), ownerModelType, ownerName);
            }
            if (parameterModel.getType() instanceof StringType && !this.validatedComponentIdContainers.contains(ownerName)) {
                this.validatedComponentIdContainers.add(ownerName);
                List componentIdParameters = owner.getAllParameterModels().stream().filter(ParameterModel::isComponentId).map(NamedObject::getName).collect(Collectors.toList());
                if (componentIdParameters.size() > 1) {
                    this.addError(owner, "The %s '%s' declares multiple parameters as Component ID. Only one parameter can serve as ID for a given Component. Affected parameters are: %s", ownerModelType, ownerName, componentIdParameters);
                }
            } else {
                this.addError(parameterModel, "Parameter '%s' in the %s '%s' is declared as a Component ID, but is of type '%s'. Only String parameters are allowed as Component ID", parameterModel.getName(), ownerModelType, ownerName, ExtensionMetadataTypeUtils.getId(parameterModel.getType()).orElse("Unknown"));
            }
            if (!ExpressionSupport.NOT_SUPPORTED.equals((Object)parameterModel.getExpressionSupport())) {
                this.addError(parameterModel, "Parameter '%s' in the %s '%s' is declared as a Component ID, but declares its expression support as '%s'. Dynamic values are not allowed for a Component ID parameter", parameterModel.getName(), ownerModelType, ownerName, parameterModel.getExpressionSupport().name());
            }
            if (!ParameterRole.BEHAVIOUR.equals((Object)parameterModel.getRole())) {
                this.addError(parameterModel, "Parameter '%s' in the %s '%s' is declared as a Component ID, but is also declared as '%s'. A parameter can't be declared both as Component ID and Content.", parameterModel.getName(), ownerModelType, ownerName, parameterModel.getRole().name());
            }
            if (parameterModel.isOverrideFromConfig()) {
                this.addError(parameterModel, "Parameter '%s' in the %s '%s' is declared as a Component ID, but is also declared as a ConfigOverride. A Component ID can't be declared as a ConfigOverride since it describe the ID of each individual component and no common global value should be used here.", parameterModel.getName(), ownerModelType, ownerName);
            }
            parameterModel.getLayoutModel().ifPresent(layout -> {
                if (layout.isText()) {
                    this.addError(parameterModel, "Parameter '%s' in the %s '%s' is declared as a Component ID, but is also declared as 'Text'. A Component ID can't be declared as a Text parameter.", parameterModel.getName(), ownerModelType, ownerName);
                }
                if (layout.isPassword()) {
                    this.addError(parameterModel, "Parameter '%s' in the %s '%s' is declared as a Component ID, but is also declared as 'Password'. A Component ID can't be declared as a Password parameter.", parameterModel.getName(), ownerModelType, ownerName);
                }
                if (layout.isQuery()) {
                    this.addError(parameterModel, "Parameter '%s' in the %s '%s' is declared as a Component ID, but is also declared as 'Query'. A Component ID can't be declared as a Query parameter.", parameterModel.getName(), ownerModelType, ownerName);
                }
            });
        }

        private void validateOAuthParameter(ParameterModel parameterModel, String ownerName, String ownerModelType) {
            parameterModel.getModelProperty(OAuthParameterModelProperty.class).ifPresent(p -> {
                if (parameterModel.getExpressionSupport() != ExpressionSupport.NOT_SUPPORTED) {
                    this.addError(parameterModel, "Parameter '%s' in the %s [%s] is an OAuth parameter yet it supports expressions. Expressions are not supported on OAuth parameters", parameterModel.getName(), ownerModelType, ownerName);
                }
                if (!ExtensionMetadataTypeUtils.isBasic(parameterModel.getType())) {
                    this.addError(parameterModel, "Parameter '%s' in the %s [%s] is an OAuth parameter but is a %s. Only basic types are supported on OAuth parameters", parameterModel.getName(), ownerModelType, ownerName, parameterModel.getType().getClass().getSimpleName());
                }
            });
        }

        private void addError(NamedObject object, String msg, Object ... args) {
            this.problemsReporter.addError(new Problem(object, String.format(msg, args)));
        }
    }
}

