/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.maven.AbstractMavenClassLoaderModelLoader;
import org.mule.runtime.module.deployment.impl.internal.maven.ArtifactClassLoaderModelBuilder;
import org.mule.runtime.module.deployment.impl.internal.maven.HeavyweightClassLoaderModelBuilder;
import org.mule.runtime.module.deployment.impl.internal.maven.LightweightClassLoaderModelBuilder;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedClassLoaderModelAttributes;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginMavenClassLoaderModelLoader
extends AbstractMavenClassLoaderModelLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PluginMavenClassLoaderModelLoader(MavenClient mavenClient) {
        super(mavenClient);
    }

    @Override
    protected org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel createClassLoaderModel(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        if (super.isHeavyPackage(artifactFile, attributes)) {
            return super.createClassLoaderModel(artifactFile, attributes, artifactType);
        }
        if (attributes instanceof PluginExtendedClassLoaderModelAttributes) {
            PluginExtendedClassLoaderModelAttributes pluginExtendedClassLoaderModelAttributes = (PluginExtendedClassLoaderModelAttributes)((Object)attributes);
            BundleDescriptor pluginBundleDescriptor = (BundleDescriptor)pluginExtendedClassLoaderModelAttributes.get(BundleDescriptor.class.getName());
            File rootFolder = pluginExtendedClassLoaderModelAttributes.getDeployableArtifactDescriptor().getRootFolder();
            Path muleArtifactJson = Paths.get(rootFolder.getAbsolutePath(), "META-INF", "mule-artifact", pluginBundleDescriptor.getGroupId(), pluginBundleDescriptor.getArtifactId(), pluginBundleDescriptor.getBaseVersion(), "classloader-model.json");
            if (muleArtifactJson.toFile().exists()) {
                return this.createHeavyPackageClassLoaderModel(artifactFile, muleArtifactJson.toFile(), attributes, Optional.empty());
            }
        }
        return this.createLightPackageClassLoaderModel(artifactFile, attributes, artifactType);
    }

    @Override
    public String getId() {
        return "mule";
    }

    @Override
    protected List<URL> addArtifactSpecificClassloaderConfiguration(ArtifactClassLoaderModelBuilder classLoaderModelBuilder) {
        return classLoaderModelBuilder.includeAdditionalPluginDependencies();
    }

    @Override
    public boolean supportsArtifactType(ArtifactType artifactType) {
        return artifactType.equals((Object)ArtifactType.PLUGIN);
    }

    @Override
    protected boolean includeProvidedDependencies(ArtifactType artifactType) {
        return false;
    }

    @Override
    protected File getClassLoaderModelDescriptor(File artifactFile) {
        return new File(artifactFile.getParent(), "classloader-model.json");
    }

    @Override
    protected LightweightClassLoaderModelBuilder newLightweightClassLoaderModelBuilder(File artifactFile, BundleDescriptor artifactBundleDescriptor, MavenClient mavenClient, Map<String, Object> attributes, Set<BundleDependency> nonProvidedDependencies) {
        LightweightClassLoaderModelBuilder lightweightClassLoaderModelBuilder = new LightweightClassLoaderModelBuilder(artifactFile, artifactBundleDescriptor, mavenClient, nonProvidedDependencies);
        this.configClassLoaderModelBuilder(lightweightClassLoaderModelBuilder, attributes);
        return lightweightClassLoaderModelBuilder;
    }

    @Override
    protected HeavyweightClassLoaderModelBuilder newHeavyWeightClassLoaderModelBuilder(File artifactFile, BundleDescriptor artifactBundleDescriptor, ClassLoaderModel packagerClassLoaderModel, Map<String, Object> attributes) {
        HeavyweightClassLoaderModelBuilder heavyweightClassLoaderModelBuilder = new HeavyweightClassLoaderModelBuilder(artifactFile, artifactBundleDescriptor, packagerClassLoaderModel);
        this.configClassLoaderModelBuilder(heavyweightClassLoaderModelBuilder, attributes);
        return heavyweightClassLoaderModelBuilder;
    }

    private void configClassLoaderModelBuilder(ArtifactClassLoaderModelBuilder classLoaderModelBuilder, Map<String, Object> attributes) {
        if (attributes instanceof PluginExtendedClassLoaderModelAttributes) {
            classLoaderModelBuilder.setDeployableArtifactDescriptor(((PluginExtendedClassLoaderModelAttributes)((Object)attributes)).getDeployableArtifactDescriptor());
        }
    }

    @Override
    protected ClassLoaderModel getPackagerClassLoaderModel(File classLoaderModelDescriptor) {
        return ClassLoaderModelJsonSerializer.deserialize(classLoaderModelDescriptor);
    }
}

