/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.List;
import java.util.Map;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.ModuleFlowProcessingTemplate;
import org.mule.runtime.core.internal.execution.NotificationFunction;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;
import org.reactivestreams.Publisher;

final class ModuleFlowExtensionsProcessingTemplate
extends ModuleFlowProcessingTemplate {
    private final SourceResultAdapter sourceMessage;
    private final SourceCompletionHandler completionHandler;

    ModuleFlowExtensionsProcessingTemplate(SourceResultAdapter sourceMessage, Processor messageProcessor, List<NotificationFunction> notificationFunctions, SourceCompletionHandler completionHandler) {
        super(messageProcessor, notificationFunctions);
        this.sourceMessage = sourceMessage;
        this.completionHandler = completionHandler;
    }

    @Override
    public CheckedFunction<CoreEvent, Map<String, Object>> getSuccessfulExecutionResponseParametersFunction() {
        return this.completionHandler::createResponseParameters;
    }

    @Override
    public CheckedFunction<CoreEvent, Map<String, Object>> getFailedExecutionResponseParametersFunction() {
        return this.completionHandler::createFailureResponseParameters;
    }

    @Override
    public SourceResultAdapter getSourceMessage() {
        return this.sourceMessage;
    }

    @Override
    public Publisher<Void> sendResponseToClient(CoreEvent response, Map<String, Object> parameters) {
        return this.completionHandler.onCompletion(response, parameters);
    }

    @Override
    public Publisher<Void> sendFailureResponseToClient(MessagingException messagingException, Map<String, Object> parameters) {
        return this.completionHandler.onFailure(messagingException, parameters);
    }

    @Override
    public void afterPhaseExecution(Either<MessagingException, CoreEvent> either) {
        either.apply(messagingException -> this.completionHandler.onTerminate(Either.left(messagingException)), event -> this.completionHandler.onTerminate(either));
    }
}

