/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.catalog.internal.loader;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class XmlMatcher {
    private final Element element;

    static Optional<XmlMatcher> match(Element element, QName qName) {
        Optional<XmlMatcher> result = Optional.empty();
        if (Objects.equals(element.getNamespaceURI(), qName.getNamespaceURI()) && Objects.equals(element.getLocalName(), qName.getLocalPart())) {
            result = Optional.of(new XmlMatcher(element));
        }
        return result;
    }

    private Stream<Node> nodeStream(NodeList nodeList) {
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item);
    }

    private XmlMatcher(Element element) {
        MetadataTypeUtils.checkArgument(MetadataTypeUtils.isNotNull(element), "Element must not be null.");
        this.element = element;
    }

    String value() {
        StringBuilder stringBuilder = new StringBuilder();
        this.nodeStream(this.element.getChildNodes()).filter(node -> node instanceof Text).map(Node::getTextContent).forEach(stringBuilder::append);
        return stringBuilder.toString();
    }

    Stream<XmlMatcher> matchMany(QName qName) {
        return this.nodeStream(this.element.getElementsByTagNameNS(qName.getNamespaceURI(), qName.getLocalPart())).filter(node -> node instanceof Element).map(node -> (Element)node).filter(element -> qName.equals(new QName(element.getNamespaceURI(), element.getLocalName()))).map(XmlMatcher::new);
    }

    private Optional<Attr> matchAttributeNode(String namespaceUri, String localPart) {
        Attr attributeNodeNS = this.element.getAttributeNodeNS(namespaceUri, localPart);
        return Optional.ofNullable(attributeNodeNS);
    }

    private Optional<String> matchAttribute(String namespaceUri, String localPart) {
        Attr attributeNodeNS = this.matchAttributeNode(namespaceUri, localPart).orElse(null);
        return Optional.ofNullable(attributeNodeNS == null ? null : attributeNodeNS.getValue());
    }

    Optional<String> matchAttribute(String localPart) {
        return this.matchAttribute(null, localPart);
    }
}

