/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.Collection;
import javax.inject.Inject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.routing.AbstractSelectiveRouter;
import org.mule.runtime.core.internal.routing.MessageProcessorExpressionPair;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;

public abstract class AbstractSelectiveRouterObjectFactory
extends AbstractComponentFactory<AbstractSelectiveRouter> {
    @Inject
    private MuleContext muleContext;
    private Processor defaultProcessor;
    private Collection<MessageProcessorExpressionPair> conditionalMessageProcessors;

    public void setDefaultRoute(MessageProcessorExpressionPair conditionalProcessor) {
        this.defaultProcessor = conditionalProcessor.getMessageProcessor();
    }

    public void setRoutes(Collection<MessageProcessorExpressionPair> conditionalMessageProcessors) {
        this.conditionalMessageProcessors = conditionalMessageProcessors;
    }

    @Override
    public AbstractSelectiveRouter doGetObject() throws Exception {
        AbstractSelectiveRouter router = this.newAbstractSelectiveRouter();
        router.setAnnotations(this.getAnnotations());
        router.setDefaultRoute(this.defaultProcessor);
        router.setMuleContext(this.muleContext);
        for (MessageProcessorExpressionPair mpfp : this.conditionalMessageProcessors) {
            router.addRoute(mpfp.getExpression(), mpfp.getMessageProcessor());
        }
        return router;
    }

    protected abstract AbstractSelectiveRouter newAbstractSelectiveRouter();
}

