/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.config.internal.dsl.SchemaConstants;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.ExecutableTypeSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;

class OperationSchemaDelegate
extends ExecutableTypeSchemaDelegate {
    public OperationSchemaDelegate(SchemaBuilder builder) {
        super(builder);
    }

    public void registerOperation(ComponentModel componentModel, DslElementSyntax dslSyntax, boolean hasImplicitConfig) {
        String typeName = StringUtils.capitalize((String)componentModel.getName()) + "Type";
        this.registerProcessorElement(componentModel, typeName, dslSyntax);
        ExtensionType extensionType = this.registerOperationType(typeName, componentModel, dslSyntax, hasImplicitConfig);
        this.registerNestedComponents(extensionType, componentModel.getNestedComponents());
    }

    void registerProcessorElement(ComponentModel componentModel, String typeName, DslElementSyntax dslSyntax) {
        TopLevelElement element = new TopLevelElement();
        element.setName(dslSyntax.getElementName());
        element.setType(new QName(this.builder.getSchema().getTargetNamespace(), typeName));
        element.setAnnotation(this.builder.createDocAnnotation(componentModel.getDescription()));
        element.setSubstitutionGroup(this.getOperationSubstitutionGroup(componentModel));
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(element);
    }

    ExtensionType registerOperationType(String name, ComponentModel operationModel, DslElementSyntax dslSyntax, boolean hasImplicitConfig) {
        ExtensionType componentType = this.createExecutableType(name, SchemaConstants.MULE_ABSTRACT_OPERATOR_TYPE, dslSyntax, hasImplicitConfig);
        this.initialiseSequence(componentType);
        ExplicitGroup sequence = componentType.getSequence();
        this.builder.addInfrastructureParameters(componentType, operationModel, sequence);
        operationModel.getParameterGroupModels().forEach(group -> this.registerParameterGroup(componentType, (ParameterGroupModel)group));
        return componentType;
    }

    private QName getOperationSubstitutionGroup(ComponentModel componentModel) {
        return this.getSubstitutionGroup(componentModel, SchemaConstants.MULE_ABSTRACT_OPERATOR);
    }
}

