/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal;

import com.google.common.base.Throwables;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.deployment.model.api.DeploymentStartException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.repository.api.BundleNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryArtifactConnectivityTestingService
implements ConnectivityTestingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemporaryArtifactConnectivityTestingService.class);
    private final ApplicationSupplier applicationSupplier;
    private Application application;

    public TemporaryArtifactConnectivityTestingService(ApplicationSupplier applicationSupplier) {
        this.applicationSupplier = applicationSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ConnectionValidationResult testConnection(Location location) {
        Preconditions.checkArgument(location != null, "identifier cannot be null");
        try {
            this.application = this.applicationSupplier.get();
        }
        catch (Exception e) {
            throw Throwables.getCausalChain((Throwable)e).stream().filter(exception -> exception.getClass().equals(ArtifactNotFoundException.class) || exception.getClass().equals(ArtifactResolutionException.class)).findFirst().map(exception -> new BundleNotFoundException((Throwable)exception)).orElse(new MuleRuntimeException(e));
        }
        try {
            try {
                this.application.install();
                this.application.init();
                this.application.start();
            }
            catch (DeploymentStartException e) {
                ConnectionValidationResult connectionValidationResult = ConnectionValidationResult.failure(e.getMessage(), e);
                if (this.application != null) {
                    this.doWithoutFail(() -> this.application.stop());
                    this.doWithoutFail(() -> this.application.dispose());
                    this.doWithoutFail(() -> FileUtils.deleteTree(this.application.getLocation()));
                }
                return connectionValidationResult;
            }
            catch (Exception e) {
                ConnectionValidationResult connectionValidationResult = Throwables.getCausalChain((Throwable)e).stream().filter(exception -> exception.getClass().equals(ConnectionException.class) && ((ConnectionException)exception).getErrorType().isPresent()).map(exception -> ConnectionValidationResult.failure(exception.getMessage(), ((ConnectionException)exception).getErrorType().get(), (Exception)exception)).findFirst().orElse(ConnectionValidationResult.failure(e.getMessage(), e));
                if (this.application != null) {
                    this.doWithoutFail(() -> this.application.stop());
                    this.doWithoutFail(() -> this.application.dispose());
                    this.doWithoutFail(() -> FileUtils.deleteTree(this.application.getLocation()));
                }
                return connectionValidationResult;
            }
            ConnectionValidationResult connectionValidationResult = this.application.getConnectivityTestingService().testConnection(location);
            return connectionValidationResult;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (this.application != null) {
                this.doWithoutFail(() -> this.application.stop());
                this.doWithoutFail(() -> this.application.dispose());
                this.doWithoutFail(() -> FileUtils.deleteTree(this.application.getLocation()));
            }
        }
    }

    public void doWithoutFail(Runnable runnable) {
        block2: {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    public static interface ApplicationSupplier {
        public Application get() throws Exception;
    }
}

