/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.soap.api.transport;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.client.DefaultOperationParameters;
import org.mule.runtime.extension.api.client.DefaultOperationParametersBuilder;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.soap.api.exception.DispatchingException;

public final class ReflectiveHttpConfigBasedRequester {
    private final String configName;
    private final ExtensionsClient client;

    public ReflectiveHttpConfigBasedRequester(String configName, ExtensionsClient client) {
        this.configName = configName;
        this.client = client;
    }

    public Pair<InputStream, Map<String, String>> get(String url, Map<String, String> headers) {
        return this.request(HttpConstants.Method.GET.toString(), url, headers, null);
    }

    public Pair<InputStream, Map<String, String>> post(String url, Map<String, String> headers, InputStream body2) {
        return this.request(HttpConstants.Method.POST.toString(), url, headers, body2);
    }

    private Pair<InputStream, Map<String, String>> request(String method, String url, Map<String, String> headers, InputStream body2) {
        DefaultOperationParametersBuilder params = DefaultOperationParameters.builder().configName(this.configName).addParameter("method", method).addParameter("url", url).addParameter("headers", new MultiMap<String, String>(headers)).addParameter("targetValue", "#[payload]");
        if (body2 != null) {
            params.addParameter("body", new TypedValue<InputStream>(body2, DataType.INPUT_STREAM));
        }
        try {
            Result<Object, Object> result = this.client.executeAsync("HTTP", "request", params.build()).get();
            Map<String, String> httpHeaders = this.getHttpHeaders(result);
            InputStream content = this.getContent(result);
            return new Pair<InputStream, Map<String, String>>(content, httpHeaders);
        }
        catch (Exception e) {
            throw new DispatchingException("Could not dispatch soap message using the [" + this.configName + "] HTTP configuration", (Throwable)e);
        }
    }

    private Map<String, String> getHttpHeaders(Result<Object, Object> result) {
        try {
            Optional<Object> httpAttributes = result.getAttributes();
            if (!httpAttributes.isPresent()) {
                throw new IllegalStateException("No Http Attributes found on the response, cannot get response headers.");
            }
            Object headers = httpAttributes.get().getClass().getMethod("getHeaders", new Class[0]).invoke(httpAttributes.get(), new Object[0]);
            Map map = (Map)headers.getClass().getMethod("toListValuesMap", new Class[0]).invoke(headers, new Object[0]);
            return map.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((List)e.getValue()).stream().collect(Collectors.joining(" "))));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
            throw new IllegalStateException("Something went wrong when introspecting the http response attributes.", e2);
        }
    }

    private InputStream getContent(Result<Object, Object> result) {
        Object output = result.getOutput();
        if (output instanceof CursorStreamProvider) {
            return (InputStream)((CursorStreamProvider)output).openCursor();
        }
        if (output instanceof InputStream) {
            return (InputStream)output;
        }
        throw new IllegalStateException("Content was expected to be an stream but got a [" + output.getClass().getName() + "]");
    }
}

